/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

public class EnrichPolicyLocks {
    private final ReadWriteLock currentStateLock = new ReentrantReadWriteLock(true);
    private final ConcurrentHashMap<String, Semaphore> policyLocks = new ConcurrentHashMap();
    private final AtomicLong policyRunCounter = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockPolicy(String policyName) {
        this.currentStateLock.readLock().lock();
        try {
            Semaphore runLock = this.policyLocks.computeIfAbsent(policyName, name -> new Semaphore(1));
            boolean acquired = runLock.tryAcquire();
            if (!acquired) {
                throw new EsRejectedExecutionException("Could not obtain lock because policy execution for [" + policyName + "] is already in progress.");
            }
            this.policyRunCounter.incrementAndGet();
        }
        finally {
            this.currentStateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnrichPolicyExecutionState captureExecutionState() {
        if (this.currentStateLock.writeLock().tryLock()) {
            try {
                long revision = this.policyRunCounter.get();
                long currentPolicyExecutions = this.policyLocks.mappingCount();
                EnrichPolicyExecutionState enrichPolicyExecutionState = new EnrichPolicyExecutionState(currentPolicyExecutions > 0L, revision);
                return enrichPolicyExecutionState;
            }
            finally {
                this.currentStateLock.writeLock().unlock();
            }
        }
        return new EnrichPolicyExecutionState(true, this.policyRunCounter.get());
    }

    boolean isSameState(EnrichPolicyExecutionState previousState) {
        EnrichPolicyExecutionState currentState = this.captureExecutionState();
        return currentState.anyPolicyInFlight == previousState.anyPolicyInFlight && currentState.executions == previousState.executions;
    }

    public void releasePolicy(String policyName) {
        this.currentStateLock.readLock().lock();
        try {
            this.policyLocks.remove(policyName);
        }
        finally {
            this.currentStateLock.readLock().unlock();
        }
    }

    public static class EnrichPolicyExecutionState {
        final boolean anyPolicyInFlight;
        final long executions;

        EnrichPolicyExecutionState(boolean anyPolicyInFlight, long executions) {
            this.anyPolicyInFlight = anyPolicyInFlight;
            this.executions = executions;
        }

        public boolean isAnyPolicyInFlight() {
            return this.anyPolicyInFlight;
        }
    }
}

