/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery.plan;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.plan.RecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.ShardRecoveryPlan;
import org.elasticsearch.indices.recovery.plan.ShardSnapshot;
import org.elasticsearch.indices.recovery.plan.ShardSnapshotsService;

public class SnapshotsRecoveryPlannerService
implements RecoveryPlannerService {
    private final Logger logger = LogManager.getLogger(SnapshotsRecoveryPlannerService.class);
    private final ShardSnapshotsService shardSnapshotsService;

    public SnapshotsRecoveryPlannerService(ShardSnapshotsService shardSnapshotsService) {
        this.shardSnapshotsService = shardSnapshotsService;
    }

    @Override
    public void computeRecoveryPlan(ShardId shardId, Store.MetadataSnapshot sourceMetadata, Store.MetadataSnapshot targetMetadata, long startingSeqNo, int translogOps, Version targetVersion, boolean useSnapshots, ActionListener<ShardRecoveryPlan> listener) {
        boolean canUseSnapshots = useSnapshots && targetVersion.onOrAfter(RecoverySettings.SNAPSHOT_RECOVERIES_SUPPORTED_VERSION);
        this.fetchLatestSnapshotsIgnoringErrors(shardId, canUseSnapshots, latestSnapshotOpt -> ActionListener.completeWith(listener, () -> this.computeRecoveryPlanWithSnapshots(sourceMetadata, targetMetadata, startingSeqNo, translogOps, (Optional<ShardSnapshot>)latestSnapshotOpt)));
    }

    private ShardRecoveryPlan computeRecoveryPlanWithSnapshots(Store.MetadataSnapshot sourceMetadata, Store.MetadataSnapshot targetMetadata, long startingSeqNo, int translogOps, Optional<ShardSnapshot> latestSnapshotOpt) {
        Store.RecoveryDiff sourceTargetDiff = sourceMetadata.recoveryDiff(targetMetadata);
        List<StoreFileMetadata> filesMissingInTarget = CollectionUtils.concatLists(sourceTargetDiff.missing, sourceTargetDiff.different);
        if (!latestSnapshotOpt.isPresent()) {
            return new ShardRecoveryPlan(ShardRecoveryPlan.SnapshotFilesToRecover.EMPTY, filesMissingInTarget, sourceTargetDiff.identical, startingSeqNo, translogOps, sourceMetadata);
        }
        ShardSnapshot latestSnapshot = latestSnapshotOpt.get();
        Store.MetadataSnapshot filesToRecoverFromSourceSnapshot = this.toMetadataSnapshot(filesMissingInTarget);
        Store.RecoveryDiff snapshotDiff = filesToRecoverFromSourceSnapshot.recoveryDiff(latestSnapshot.getMetadataSnapshot());
        ShardRecoveryPlan.SnapshotFilesToRecover snapshotFilesToRecover = snapshotDiff.identical.isEmpty() ? ShardRecoveryPlan.SnapshotFilesToRecover.EMPTY : new ShardRecoveryPlan.SnapshotFilesToRecover(latestSnapshot.getIndexId(), latestSnapshot.getRepository(), latestSnapshot.getSnapshotFiles(snapshotDiff.identical));
        return new ShardRecoveryPlan(snapshotFilesToRecover, CollectionUtils.concatLists(snapshotDiff.missing, snapshotDiff.different), sourceTargetDiff.identical, startingSeqNo, translogOps, sourceMetadata);
    }

    private void fetchLatestSnapshotsIgnoringErrors(final ShardId shardId, boolean useSnapshots, final Consumer<Optional<ShardSnapshot>> listener) {
        if (!useSnapshots) {
            listener.accept(Optional.empty());
            return;
        }
        ActionListener<Optional<ShardSnapshot>> listenerIgnoringErrors = new ActionListener<Optional<ShardSnapshot>>(){

            @Override
            public void onResponse(Optional<ShardSnapshot> shardSnapshotData) {
                listener.accept(shardSnapshotData);
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsRecoveryPlannerService.this.logger.warn((Message)new ParameterizedMessage("Unable to fetch available snapshots for shard {}", (Object)shardId), (Throwable)e);
                listener.accept(Optional.empty());
            }
        };
        this.shardSnapshotsService.fetchLatestSnapshotsForShard(shardId, listenerIgnoringErrors);
    }

    private Store.MetadataSnapshot toMetadataSnapshot(List<StoreFileMetadata> files) {
        return new Store.MetadataSnapshot(files.stream().collect(Collectors.toMap(StoreFileMetadata::name, Function.identity())), Collections.emptyMap(), 0L);
    }
}

