/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.db.Network;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Subdivision;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.geoip.DatabaseReaderLazyLoader;
import org.elasticsearch.ingest.geoip.DatabaseRegistry;
import org.elasticsearch.ingest.geoip.GeoIpTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;

public final class GeoIpProcessor
extends AbstractProcessor {
    public static final String TYPE = "geoip";
    private static final String CITY_DB_SUFFIX = "-City";
    private static final String COUNTRY_DB_SUFFIX = "-Country";
    private static final String ASN_DB_SUFFIX = "-ASN";
    private final String field;
    private final Supplier<Boolean> isValid;
    private final String targetField;
    private final CheckedSupplier<DatabaseReaderLazyLoader, IOException> supplier;
    private final Set<Property> properties;
    private final boolean ignoreMissing;
    private final boolean firstOnly;

    GeoIpProcessor(String tag, String description, String field, CheckedSupplier<DatabaseReaderLazyLoader, IOException> supplier, Supplier<Boolean> isValid, String targetField, Set<Property> properties, boolean ignoreMissing, boolean firstOnly) {
        super(tag, description);
        this.field = field;
        this.isValid = isValid;
        this.targetField = targetField;
        this.supplier = supplier;
        this.properties = properties;
        this.ignoreMissing = ignoreMissing;
        this.firstOnly = firstOnly;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws IOException {
        Object ip = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (!this.isValid.get().booleanValue()) {
            ingestDocument.appendFieldValue("tags", (Object)"_geoip_expired_database", false);
            return ingestDocument;
        }
        if (ip == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (ip == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot extract geoip information.");
        }
        if (ip instanceof String) {
            Map<String, Object> geoData = this.getGeoData((String)ip);
            if (!geoData.isEmpty()) {
                ingestDocument.setFieldValue(this.targetField, geoData);
            }
        } else if (ip instanceof List) {
            boolean match = false;
            ArrayList<Map<String, Object>> geoDataList = new ArrayList<Map<String, Object>>(((List)ip).size());
            for (Object ipAddr : (List)ip) {
                if (!(ipAddr instanceof String)) {
                    throw new IllegalArgumentException("array in field [" + this.field + "] should only contain strings");
                }
                Map<String, Object> geoData = this.getGeoData((String)ipAddr);
                if (geoData.isEmpty()) {
                    geoDataList.add(null);
                    continue;
                }
                if (this.firstOnly) {
                    ingestDocument.setFieldValue(this.targetField, geoData);
                    return ingestDocument;
                }
                match = true;
                geoDataList.add(geoData);
            }
            if (match) {
                ingestDocument.setFieldValue(this.targetField, geoDataList);
            }
        } else {
            throw new IllegalArgumentException("field [" + this.field + "] should contain only string or array of strings");
        }
        return ingestDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getGeoData(String ip) throws IOException {
        DatabaseReaderLazyLoader lazyLoader = (DatabaseReaderLazyLoader)this.supplier.get();
        try {
            Map<Object, Object> geoData;
            String databaseType = lazyLoader.getDatabaseType();
            InetAddress ipAddress = InetAddresses.forString((String)ip);
            if (databaseType.endsWith(CITY_DB_SUFFIX)) {
                try {
                    geoData = this.retrieveCityGeoData(lazyLoader, ipAddress);
                }
                catch (AddressNotFoundRuntimeException e) {
                    geoData = Collections.emptyMap();
                }
            } else if (databaseType.endsWith(COUNTRY_DB_SUFFIX)) {
                try {
                    geoData = this.retrieveCountryGeoData(lazyLoader, ipAddress);
                }
                catch (AddressNotFoundRuntimeException e) {
                    geoData = Collections.emptyMap();
                }
            } else if (databaseType.endsWith(ASN_DB_SUFFIX)) {
                try {
                    geoData = this.retrieveAsnGeoData(lazyLoader, ipAddress);
                }
                catch (AddressNotFoundRuntimeException e) {
                    geoData = Collections.emptyMap();
                }
            } else {
                throw new ElasticsearchParseException("Unsupported database type [" + lazyLoader.getDatabaseType() + "]", (Throwable)new IllegalStateException(), new Object[0]);
            }
            Map<String, Object> map = geoData;
            return map;
        }
        finally {
            lazyLoader.postLookup();
        }
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    String getDatabaseType() throws IOException {
        return ((DatabaseReaderLazyLoader)this.supplier.get()).getDatabaseType();
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    private Map<String, Object> retrieveCityGeoData(DatabaseReaderLazyLoader lazyLoader, InetAddress ipAddress) {
        CityResponse response = lazyLoader.getCity(ipAddress);
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case COUNTRY_ISO_CODE: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) break;
                    geoData.put("country_iso_code", countryIsoCode);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) break;
                    geoData.put("country_name", countryName);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put("continent_name", continentName);
                    break;
                }
                case REGION_ISO_CODE: {
                    String countryIso = country.getIsoCode();
                    String subdivisionIso = subdivision.getIsoCode();
                    if (countryIso == null || subdivisionIso == null) break;
                    String regionIsoCode = countryIso + "-" + subdivisionIso;
                    geoData.put("region_iso_code", regionIsoCode);
                    break;
                }
                case REGION_NAME: {
                    String subdivisionName = subdivision.getName();
                    if (subdivisionName == null) break;
                    geoData.put("region_name", subdivisionName);
                    break;
                }
                case CITY_NAME: {
                    String cityName = city.getName();
                    if (cityName == null) break;
                    geoData.put("city_name", cityName);
                    break;
                }
                case TIMEZONE: {
                    String locationTimeZone = location.getTimeZone();
                    if (locationTimeZone == null) break;
                    geoData.put("timezone", locationTimeZone);
                    break;
                }
                case LOCATION: {
                    Double latitude = location.getLatitude();
                    Double longitude = location.getLongitude();
                    if (latitude == null || longitude == null) break;
                    HashMap<String, Double> locationObject = new HashMap<String, Double>();
                    locationObject.put("lat", latitude);
                    locationObject.put("lon", longitude);
                    geoData.put("location", locationObject);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveCountryGeoData(DatabaseReaderLazyLoader lazyLoader, InetAddress ipAddress) {
        CountryResponse response = lazyLoader.getCountry(ipAddress);
        Country country = response.getCountry();
        Continent continent = response.getContinent();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case COUNTRY_ISO_CODE: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) break;
                    geoData.put("country_iso_code", countryIsoCode);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) break;
                    geoData.put("country_name", countryName);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put("continent_name", continentName);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveAsnGeoData(DatabaseReaderLazyLoader lazyLoader, InetAddress ipAddress) {
        AsnResponse response = lazyLoader.getAsn(ipAddress);
        Integer asn = response.getAutonomousSystemNumber();
        String organization_name = response.getAutonomousSystemOrganization();
        Network network = response.getNetwork();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case ASN: {
                    if (asn == null) break;
                    geoData.put("asn", asn);
                    break;
                }
                case ORGANIZATION_NAME: {
                    if (organization_name == null) break;
                    geoData.put("organization_name", organization_name);
                    break;
                }
                case NETWORK: {
                    if (network == null) break;
                    geoData.put("network", network.toString());
                }
            }
        }
        return geoData;
    }

    static final class AddressNotFoundRuntimeException
    extends RuntimeException {
        AddressNotFoundRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    static enum Property {
        IP,
        COUNTRY_ISO_CODE,
        COUNTRY_NAME,
        CONTINENT_NAME,
        REGION_ISO_CODE,
        REGION_NAME,
        CITY_NAME,
        TIMEZONE,
        LOCATION,
        ASN,
        ORGANIZATION_NAME,
        NETWORK;

        static final EnumSet<Property> ALL_CITY_PROPERTIES;
        static final EnumSet<Property> ALL_COUNTRY_PROPERTIES;
        static final EnumSet<Property> ALL_ASN_PROPERTIES;

        public static Property parseProperty(String databaseType, String value) {
            EnumSet<Property> validProperties = EnumSet.noneOf(Property.class);
            if (databaseType.endsWith(GeoIpProcessor.CITY_DB_SUFFIX)) {
                validProperties = ALL_CITY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.COUNTRY_DB_SUFFIX)) {
                validProperties = ALL_COUNTRY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.ASN_DB_SUFFIX)) {
                validProperties = ALL_ASN_PROPERTIES;
            }
            try {
                Property property = Property.valueOf(value.toUpperCase(Locale.ROOT));
                if (!validProperties.contains((Object)property)) {
                    throw new IllegalArgumentException("invalid");
                }
                return property;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("illegal property value [" + value + "]. valid values are " + Arrays.toString(validProperties.toArray()));
            }
        }

        static {
            ALL_CITY_PROPERTIES = EnumSet.of(IP, new Property[]{COUNTRY_ISO_CODE, COUNTRY_NAME, CONTINENT_NAME, REGION_ISO_CODE, REGION_NAME, CITY_NAME, TIMEZONE, LOCATION});
            ALL_COUNTRY_PROPERTIES = EnumSet.of(IP, CONTINENT_NAME, COUNTRY_NAME, COUNTRY_ISO_CODE);
            ALL_ASN_PROPERTIES = EnumSet.of(IP, ASN, ORGANIZATION_NAME, NETWORK);
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final Set<Property> DEFAULT_CITY_PROPERTIES = Collections.unmodifiableSet(EnumSet.of(Property.CONTINENT_NAME, new Property[]{Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.LOCATION}));
        static final Set<Property> DEFAULT_COUNTRY_PROPERTIES = Collections.unmodifiableSet(EnumSet.of(Property.CONTINENT_NAME, Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE));
        static final Set<Property> DEFAULT_ASN_PROPERTIES = Collections.unmodifiableSet(EnumSet.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK));
        private final DatabaseRegistry databaseRegistry;
        private final ClusterService clusterService;

        List<DatabaseReaderLazyLoader> getAllDatabases() {
            return this.databaseRegistry.getAllDatabases();
        }

        public Factory(DatabaseRegistry databaseRegistry, ClusterService clusterService) {
            this.databaseRegistry = databaseRegistry;
            this.clusterService = clusterService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GeoIpProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws IOException {
            Set<Property> properties;
            String databaseType;
            String ipField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)GeoIpProcessor.TYPE);
            String databaseFile = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"database_file", (String)"GeoLite2-City.mmdb");
            List propertyNames = ConfigurationUtils.readOptionalList((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"properties");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            boolean firstOnly = ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"first_only", (boolean)true);
            boolean fallbackUsingDefaultDatabases = ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"fallback_to_default_databases", (boolean)true);
            DatabaseReaderLazyLoader lazyLoader = this.databaseRegistry.getDatabase(databaseFile, fallbackUsingDefaultDatabases);
            if (lazyLoader == null) {
                throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"database_file", (String)("database file [" + databaseFile + "] doesn't exist"));
            }
            try {
                databaseType = lazyLoader.getDatabaseType();
            }
            finally {
                lazyLoader.postLookup();
            }
            if (propertyNames != null) {
                EnumSet<Property> modifiableProperties = EnumSet.noneOf(Property.class);
                for (String fieldName : propertyNames) {
                    try {
                        modifiableProperties.add(Property.parseProperty(databaseType, fieldName));
                    }
                    catch (IllegalArgumentException e) {
                        throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"properties", (String)e.getMessage());
                    }
                }
                properties = Collections.unmodifiableSet(modifiableProperties);
            } else if (databaseType.endsWith(GeoIpProcessor.CITY_DB_SUFFIX)) {
                properties = DEFAULT_CITY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.COUNTRY_DB_SUFFIX)) {
                properties = DEFAULT_COUNTRY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.ASN_DB_SUFFIX)) {
                properties = DEFAULT_ASN_PROPERTIES;
            } else {
                throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"database_file", (String)("Unsupported database type [" + databaseType + "]"));
            }
            CheckedSupplier supplier = () -> {
                DatabaseReaderLazyLoader loader = this.databaseRegistry.getDatabase(databaseFile, fallbackUsingDefaultDatabases);
                if (loader == null) {
                    throw new ResourceNotFoundException("database file [" + databaseFile + "] doesn't exist", new Object[0]);
                }
                String expectedSuffix = databaseType.substring(databaseType.lastIndexOf(45));
                assert (loader.getDatabaseType().endsWith(expectedSuffix)) : "database type [" + loader.getDatabaseType() + "] doesn't match with expected suffix [" + expectedSuffix + "]";
                return loader;
            };
            Supplier<Boolean> isValid = () -> {
                ClusterState currentState = this.clusterService.state();
                assert (currentState != null);
                PersistentTasksCustomMetadata.PersistentTask task = PersistentTasksCustomMetadata.getTaskWithId((ClusterState)currentState, (String)"geoip-downloader");
                if (task == null || task.getState() == null) {
                    return true;
                }
                GeoIpTaskState state = (GeoIpTaskState)task.getState();
                GeoIpTaskState.Metadata metadata = state.getDatabases().get(databaseFile);
                if (metadata == null) {
                    return true;
                }
                boolean valid = metadata.isValid(currentState.metadata().settings());
                if (valid && metadata.isCloseToExpiration()) {
                    HeaderWarning.addWarning((String)"database [{}] was not updated for over 25 days, geoip processor will stop working if there is no update for 30 days", (Object[])new Object[]{databaseFile});
                }
                return valid;
            };
            return new GeoIpProcessor(processorTag, description, ipField, (CheckedSupplier<DatabaseReaderLazyLoader, IOException>)supplier, isValid, targetField, properties, ignoreMissing, firstOnly);
        }
    }
}

