/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.jdk.JavaVersion;
import org.elasticsearch.license.License;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;

class NodeDeprecationChecks {
    NodeDeprecationChecks() {
    }

    static DeprecationIssue checkPidfile(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, Environment.PIDFILE_SETTING, Environment.NODE_PIDFILE_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/7.4/breaking-changes-7.4.html#deprecate-pidfile");
    }

    static DeprecationIssue checkProcessors(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, EsExecutors.PROCESSORS_SETTING, EsExecutors.NODE_PROCESSORS_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/7.4/breaking-changes-7.4.html#deprecate-processors");
    }

    static DeprecationIssue checkMissingRealmOrders(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Set orderNotConfiguredRealms = RealmSettings.getRealmSettings((Settings)settings).entrySet().stream().filter(e -> false == ((Settings)e.getValue()).hasValue("order")).filter(e -> ((Settings)e.getValue()).getAsBoolean("enabled", Boolean.valueOf(true))).map(e -> RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)((RealmConfig.RealmIdentifier)e.getKey())) + "order").collect(Collectors.toSet());
        if (orderNotConfiguredRealms.isEmpty()) {
            return null;
        }
        String details = String.format(Locale.ROOT, "Found realms without order config: [%s]. In next major release, node will fail to start with missing realm order.", String.join((CharSequence)"; ", orderNotConfiguredRealms));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Realm order will be required in next major release.", "https://www.elastic.co/guide/en/elasticsearch/reference/7.7/breaking-changes-7.7.html#deprecate-missing-realm-order", details, false, null);
    }

    static DeprecationIssue checkUniqueRealmOrders(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Map orderToRealmSettings = RealmSettings.getRealmSettings((Settings)settings).entrySet().stream().filter(e -> ((Settings)e.getValue()).hasValue("order")).collect(Collectors.groupingBy(e -> ((Settings)e.getValue()).get("order"), Collectors.mapping(e -> RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)((RealmConfig.RealmIdentifier)e.getKey())) + "order", Collectors.toList())));
        Set duplicateOrders = orderToRealmSettings.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.toSet());
        if (duplicateOrders.isEmpty()) {
            return null;
        }
        String details = String.format(Locale.ROOT, "Found multiple realms configured with the same order: [%s]. In next major release, node will fail to start with duplicated realm order.", String.join((CharSequence)"; ", duplicateOrders));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Realm orders must be unique in next major release.", "https://www.elastic.co/guide/en/elasticsearch/reference/7.7/breaking-changes-7.7.html#deprecate-duplicated-realm-orders", details, false, null);
    }

    static DeprecationIssue checkImplicitlyDisabledSecurityOnBasicAndTrial(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (!XPackSettings.SECURITY_ENABLED.exists(settings) && (licenseState.getOperationMode().equals((Object)License.OperationMode.BASIC) || licenseState.getOperationMode().equals((Object)License.OperationMode.TRIAL))) {
            String details = "The default behavior of disabling security on " + licenseState.getOperationMode().description() + " licenses is deprecated. In a later version of Elasticsearch, the value of [xpack.security.enabled] will default to \"true\" , regardless of the license level. See https://www.elastic.co/guide/en/elasticsearch/reference/" + Version.CURRENT.major + "." + Version.CURRENT.minor + "/security-minimal-setup.html to enable security, or explicitly disable security by setting [xpack.security.enabled] to \"false\" in elasticsearch.yml";
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Security is enabled by default for all licenses in the next major version.", "https://www.elastic.co/guide/en/elasticsearch/reference/7.14/migrating-7.14.html#implicitly-disabled-security", details, false, null);
        }
        return null;
    }

    static DeprecationIssue checkImplicitlyDisabledBasicRealms(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        String details;
        Map realmSettings = RealmSettings.getRealmSettings((Settings)settings);
        if (realmSettings.isEmpty()) {
            return null;
        }
        boolean anyRealmEnabled = false;
        HashSet unconfiguredBasicRealms = new HashSet(org.elasticsearch.core.Set.of((Object)"file", (Object)"native"));
        for (Map.Entry realmSetting : realmSettings.entrySet()) {
            anyRealmEnabled = anyRealmEnabled || ((Settings)realmSetting.getValue()).getAsBoolean("enabled", Boolean.valueOf(true)) != false;
            unconfiguredBasicRealms.remove(((RealmConfig.RealmIdentifier)realmSetting.getKey()).getType());
        }
        if (!anyRealmEnabled) {
            List explicitlyDisabledBasicRealms = Sets.difference((Set)org.elasticsearch.core.Set.of((Object)"file", (Object)"native"), unconfiguredBasicRealms).stream().sorted().collect(Collectors.toList());
            if (explicitlyDisabledBasicRealms.isEmpty()) {
                return null;
            }
            details = String.format(Locale.ROOT, "Found explicitly disabled basic %s: [%s]. But %s will be enabled because no other realms are configured or enabled. In next major release, explicitly disabled basic realms will remain disabled.", explicitlyDisabledBasicRealms.size() == 1 ? "realm" : "realms", Strings.collectionToDelimitedString(explicitlyDisabledBasicRealms, (String)","), explicitlyDisabledBasicRealms.size() == 1 ? "it" : "they");
        } else {
            if (unconfiguredBasicRealms.isEmpty()) {
                return null;
            }
            details = String.format(Locale.ROOT, "Found implicitly disabled basic %s: [%s]. %s disabled because there are other explicitly configured realms.In next major release, basic realms will always be enabled unless explicitly disabled.", unconfiguredBasicRealms.size() == 1 ? "realm" : "realms", Strings.collectionToDelimitedString(unconfiguredBasicRealms, (String)","), unconfiguredBasicRealms.size() == 1 ? "It is" : "They are");
        }
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "File and/or native realms are enabled by default in next major release.", "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/deprecated-7.13.html#implicitly-disabled-basic-realms", details, false, null);
    }

    static DeprecationIssue checkReservedPrefixedRealmNames(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Map realmSettings = RealmSettings.getRealmSettings((Settings)settings);
        if (realmSettings.isEmpty()) {
            return null;
        }
        ArrayList<RealmConfig.RealmIdentifier> reservedPrefixedRealmIdentifiers = new ArrayList<RealmConfig.RealmIdentifier>();
        for (RealmConfig.RealmIdentifier realmIdentifier : realmSettings.keySet()) {
            if (!realmIdentifier.getName().startsWith("_")) continue;
            reservedPrefixedRealmIdentifiers.add(realmIdentifier);
        }
        if (reservedPrefixedRealmIdentifiers.isEmpty()) {
            return null;
        }
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Realm names cannot start with [_] in a future major release.", "https://www.elastic.co/guide/en/elasticsearch/reference/7.14/deprecated-7.14.html#reserved-prefixed-realm-names", String.format(Locale.ROOT, "Found realm " + (reservedPrefixedRealmIdentifiers.size() == 1 ? "name" : "names") + " with reserved prefix [%s]: [%s]. In a future major release, node will fail to start if any realm names start with reserved prefix.", "_", reservedPrefixedRealmIdentifiers.stream().map(rid -> "xpack.security.authc.realms." + rid.getType() + "." + rid.getName()).sorted().collect(Collectors.joining("; "))), false, null);
    }

    static DeprecationIssue checkThreadPoolListenerQueueSize(Settings settings) {
        return NodeDeprecationChecks.checkThreadPoolListenerSetting("thread_pool.listener.queue_size", settings);
    }

    static DeprecationIssue checkThreadPoolListenerSize(Settings settings) {
        return NodeDeprecationChecks.checkThreadPoolListenerSetting("thread_pool.listener.size", settings);
    }

    private static DeprecationIssue checkThreadPoolListenerSetting(String name, Settings settings) {
        FixedExecutorBuilder builder = new FixedExecutorBuilder(settings, "listener", 1, -1, "thread_pool.listener", true);
        List listenerSettings = builder.getRegisteredSettings();
        Optional<Setting> setting = listenerSettings.stream().filter(s -> s.getKey().equals(name)).findFirst();
        assert (setting.isPresent());
        return NodeDeprecationChecks.checkRemovedSetting(settings, setting.get(), "https://www.elastic.co/guide/en/elasticsearch/reference/7.x/breaking-changes-7.7.html#deprecate-listener-thread-pool");
    }

    public static DeprecationIssue checkClusterRemoteConnectSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, RemoteClusterService.ENABLE_REMOTE_CLUSTERS, Setting.boolSetting((String)"node.remote_cluster_client", (Setting)RemoteClusterService.ENABLE_REMOTE_CLUSTERS, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope}), "https://www.elastic.co/guide/en/elasticsearch/reference/7.7/breaking-changes-7.7.html#deprecate-cluster-remote-connect");
    }

    public static DeprecationIssue checkNodeLocalStorageSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, Node.NODE_LOCAL_STORAGE_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/7.8/breaking-changes-7.8.html#deprecate-node-local-storage");
    }

    public static DeprecationIssue checkNodeBasicLicenseFeatureEnabledSetting(Settings settings, Setting<?> setting) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, setting, "https://www.elastic.co/guide/en/elasticsearch/reference/7.8/breaking-changes-7.8.html#deprecate-basic-license-feature-enabled");
    }

    public static DeprecationIssue checkGeneralScriptSizeSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, ScriptService.SCRIPT_GENERAL_CACHE_SIZE_SETTING, ScriptService.SCRIPT_CACHE_SIZE_SETTING, "a script context", "https://www.elastic.co/guide/en/elasticsearch/reference/7.9/breaking-changes-7.9.html#deprecate_general_script_cache_size");
    }

    public static DeprecationIssue checkGeneralScriptExpireSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, ScriptService.SCRIPT_GENERAL_CACHE_EXPIRE_SETTING, ScriptService.SCRIPT_CACHE_EXPIRE_SETTING, "a script context", "https://www.elastic.co/guide/en/elasticsearch/reference/7.9/breaking-changes-7.9.html#deprecate_general_script_expire");
    }

    public static DeprecationIssue checkGeneralScriptCompileSettings(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, ScriptService.SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING, ScriptService.SCRIPT_MAX_COMPILATIONS_RATE_SETTING, "a script context", "https://www.elastic.co/guide/en/elasticsearch/reference/7.9/breaking-changes-7.9.html#deprecate_general_script_compile_rate");
    }

    public static DeprecationIssue checkLegacyRoleSettings(Setting<Boolean> legacyRoleSetting, Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, legacyRoleSetting, NodeRoleSettings.NODE_ROLES_SETTING, (String v, Settings s) -> DiscoveryNode.getRolesFromSettings((Settings)s).stream().map(DiscoveryNodeRole::roleName).collect(Collectors.joining(",")), "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html#breaking_80_settings_changes");
    }

    static DeprecationIssue checkBootstrapSystemCallFilterSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, BootstrapSettings.SYSTEM_CALL_FILTER_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/breaking-changes-7.13.html#deprecate-system-call-filter-setting");
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting<?> replacementSetting, String url) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, (String v, Settings s) -> v, url);
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting<?> replacementSetting, BiFunction<String, Settings, String> replacementValue, String url) {
        assert (deprecatedSetting.isDeprecated()) : deprecatedSetting;
        if (!deprecatedSetting.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String replacementSettingKey = replacementSetting.getKey();
        String value = deprecatedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "setting [%s] is deprecated in favor of setting [%s]", deprecatedSettingKey, replacementSettingKey);
        String details = String.format(Locale.ROOT, "the setting [%s] is currently set to [%s], instead set [%s] to [%s]", deprecatedSettingKey, value, replacementSettingKey, replacementValue.apply(value, settings));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting.AffixSetting<?> replacementSetting, String star, String url) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, (v, s) -> v, star, url);
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting.AffixSetting<?> replacementSetting, BiFunction<String, Settings, String> replacementValue, String star, String url) {
        assert (deprecatedSetting.isDeprecated()) : deprecatedSetting;
        if (!deprecatedSetting.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String replacementSettingKey = replacementSetting.getKey();
        String value = deprecatedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "setting [%s] is deprecated in favor of grouped setting [%s]", deprecatedSettingKey, replacementSettingKey);
        String details = String.format(Locale.ROOT, "the setting [%s] is currently set to [%s], instead set [%s] to [%s] where * is %s", deprecatedSettingKey, value, replacementSettingKey, replacementValue.apply(value, settings), star);
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
    }

    static DeprecationIssue checkRemovedSetting(Settings settings, Setting<?> removedSetting, String url) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, removedSetting, url, DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkRemovedSetting(Settings settings, Setting<?> removedSetting, String url, DeprecationIssue.Level deprecationLevel) {
        if (!removedSetting.exists(settings)) {
            return null;
        }
        String removedSettingKey = removedSetting.getKey();
        String value = removedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "setting [%s] is deprecated and will be removed in the next major version", removedSettingKey);
        String details = String.format(Locale.ROOT, "the setting [%s] is currently set to [%s], remove this setting", removedSettingKey, value);
        return new DeprecationIssue(deprecationLevel, message, url, details, false, null);
    }

    static DeprecationIssue javaVersionCheck(Settings nodeSettings, PluginsAndModules plugins, ClusterState clusterState, XPackLicenseState licenseState) {
        JavaVersion javaVersion = JavaVersion.current();
        if (javaVersion.compareTo(JavaVersion.parse((String)"11")) < 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Java 11 is required", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html#breaking_80_packaging_changes", "Java 11 will be required for future versions of Elasticsearch, this node is running version [" + javaVersion.toString() + "]. Consider switching to a distribution of Elasticsearch with a bundled JDK. If you are already using a distribution with a bundled JDK, ensure the JAVA_HOME environment variable is not set.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkMultipleDataPaths(Settings nodeSettings, PluginsAndModules plugins, ClusterState clusterState, XPackLicenseState licenseState) {
        List dataPaths = (List)Environment.PATH_DATA_SETTING.get(nodeSettings);
        if (dataPaths.size() > 1) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "multiple [path.data] entries are deprecated, use a single data directory", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html#breaking_80_packaging_changes", "Multiple data paths are deprecated. Instead, use RAID or other system level features to utilize multiple disks.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkDataPathsList(Settings nodeSettings, PluginsAndModules plugins, ClusterState clusterState, XPackLicenseState licenseState) {
        if (Environment.dataPathUsesList((Settings)nodeSettings)) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "[path.data] in a list is deprecated, use a string value", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html#breaking_80_packaging_changes", "Configuring [path.data] with a list is deprecated. Instead specify as a string value.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkSharedDataPathSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (Environment.PATH_SHARED_DATA_SETTING.exists(settings)) {
            String message = String.format(Locale.ROOT, "setting [%s] is deprecated and will be removed in a future version", Environment.PATH_SHARED_DATA_SETTING.getKey());
            String url = "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/breaking-changes-7.13.html#deprecate-shared-data-path-setting";
            String details = "Found shared data path configured. Discontinue use of this setting.";
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/breaking-changes-7.13.html#deprecate-shared-data-path-setting", "Found shared data path configured. Discontinue use of this setting.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkSingleDataNodeWatermarkSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (!((Boolean)DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.get(settings)).booleanValue() && DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.exists(settings)) {
            String key = DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.getKey();
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, String.format(Locale.ROOT, "setting [%s=false] is deprecated and will not be available in a future version", key), "https://www.elastic.co/guide/en/elasticsearch/reference/7.14/breaking-changes-7.14.html#deprecate-single-data-node-watermark", String.format(Locale.ROOT, "found [%s] configured to false. Discontinue use of this setting or set it to true.", key), false, null);
        }
        if (!((Boolean)DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.get(settings)).booleanValue() && clusterState.getNodes().getDataNodes().size() == 1 && clusterState.getNodes().getLocalNode().isMasterNode()) {
            String key = DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.getKey();
            String disableDiskDecider = DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.getKey();
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, String.format(Locale.ROOT, "the default value [false] of setting [%s] is deprecated and will be changed to true in a future version. This cluster has only one data node and behavior will therefore change when upgrading", key), "https://www.elastic.co/guide/en/elasticsearch/reference/7.14/breaking-changes-7.14.html#deprecate-single-data-node-watermark", String.format(Locale.ROOT, "found [%s] defaulting to false on a single data node cluster. Set it to true to avoid this warning. Consider using [%s] to disable disk based allocation", key, disableDiskDecider), false, null);
        }
        return null;
    }

    static DeprecationIssue checkMonitoringExporterPassword(Settings settings, PluginsAndModules pluginsAndModules, ClusterState cs, XPackLicenseState licenseState) {
        Setting.AffixSetting AUTH_PASSWORD_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"auth.password", s -> Setting.simpleString((String)s, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        List passwords = AUTH_PASSWORD_SETTING.getAllConcreteSettings(settings).sorted(Comparator.comparing(Setting::getKey)).collect(Collectors.toList());
        if (passwords.isEmpty()) {
            return null;
        }
        String passwordSettings = passwords.stream().map(Setting::getKey).collect(Collectors.joining(","));
        String message = String.format(Locale.ROOT, "non-secure passwords for monitoring exporters [%s] are deprecated and will be removed in the next major version", passwordSettings);
        String details = String.format(Locale.ROOT, "replace the non-secure monitoring exporter password setting(s) [%s] with their secure 'auth.secure_password' replacement", passwordSettings);
        String url = "https://www.elastic.co/guide/en/elasticsearch/reference/7.7/monitoring-settings.html#http-exporter-settings";
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, "https://www.elastic.co/guide/en/elasticsearch/reference/7.7/monitoring-settings.html#http-exporter-settings", details, false, null);
    }

    static DeprecationIssue checkClusterRoutingAllocationIncludeRelocationsSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_INCLUDE_RELOCATIONS_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/master/migrating-8.0.html#breaking_80_allocation_changes", DeprecationIssue.Level.CRITICAL);
    }
}

