/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.joda.JodaDeprecationPatterns;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingSlowLog;
import org.elasticsearch.index.SearchSlowLog;
import org.elasticsearch.index.SlowLogLevel;
import org.elasticsearch.xpack.deprecation.ClusterDeprecationChecks;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;

public class IndexDeprecationChecks {
    private static final Set<String> TYPES_THAT_DONT_COUNT;

    private static void fieldLevelMappingIssue(IndexMetadata indexMetadata, BiConsumer<MappingMetadata, Map<String, Object>> checker) {
        for (ObjectCursor mappingMetadata : indexMetadata.getMappings().values()) {
            Map sourceAsMap = ((MappingMetadata)mappingMetadata.value).sourceAsMap();
            checker.accept((MappingMetadata)mappingMetadata.value, sourceAsMap);
        }
    }

    static List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate, BiFunction<String, Map.Entry<?, ?>, String> fieldFormatter) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add("[" + fieldFormatter.apply(type, entry) + "]");
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add("[" + fieldFormatter.apply(type, entry) + ", multifield: " + multifieldEntry.getKey() + "]");
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, multifieldValueMap, predicate, fieldFormatter));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, valueMap, predicate, fieldFormatter));
        }
        return issues;
    }

    private static String formatDateField(String type, Map.Entry<?, ?> entry) {
        Map value = (Map)entry.getValue();
        return "type: " + type + ", field: " + entry.getKey() + ", format: " + value.get("format") + ", suggestion: " + JodaDeprecationPatterns.formatSuggestion((String)((String)value.get("format")));
    }

    private static String formatField(String type, Map.Entry<?, ?> entry) {
        return "type: " + type + ", field: " + entry.getKey();
    }

    static DeprecationIssue oldIndicesCheck(IndexMetadata indexMetadata) {
        Version createdWith = indexMetadata.getCreationVersion();
        if (createdWith.before(Version.V_7_0_0)) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Index created before 7.0", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html", "This index was created using version: " + createdWith, false, null);
        }
        return null;
    }

    static DeprecationIssue tooManyFieldsCheck(IndexMetadata indexMetadata) {
        if (indexMetadata.getSettings().get(IndexSettings.DEFAULT_FIELD_SETTING.getKey()) == null) {
            AtomicInteger fieldCount = new AtomicInteger(0);
            IndexDeprecationChecks.fieldLevelMappingIssue(indexMetadata, (mappingMetadata, sourceAsMap) -> fieldCount.addAndGet(IndexDeprecationChecks.countFieldsRecursively(mappingMetadata.type(), sourceAsMap)));
            if (fieldCount.get() > 1024) {
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Number of fields exceeds automatic field expansion limit", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_limiting_the_number_of_auto_expanded_fields", "This index has [" + fieldCount.get() + "] fields, which exceeds the automatic field expansion limit of 1024 and does not have [" + IndexSettings.DEFAULT_FIELD_SETTING.getKey() + "] set, which may cause queries which use automatic field expansion, such as query_string, simple_query_string, and multi_match to fail if fields are not explicitly specified in the query.", false, null);
            }
        }
        return null;
    }

    static DeprecationIssue deprecatedDateTimeFormat(IndexMetadata indexMetadata) {
        Version createdWith = indexMetadata.getCreationVersion();
        if (createdWith.before(Version.V_7_0_0)) {
            ArrayList fields = new ArrayList();
            IndexDeprecationChecks.fieldLevelMappingIssue(indexMetadata, (mappingMetadata, sourceAsMap) -> fields.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetadata.type(), sourceAsMap, IndexDeprecationChecks::isDateFieldWithDeprecatedPattern, IndexDeprecationChecks::formatDateField)));
            if (fields.size() > 0) {
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Date field format uses patterns which has changed meaning in 7.0", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#breaking_70_java_time_changes", "This index has date fields with deprecated formats: " + fields + ". " + "Use new java.time date format specifiers.", false, null);
            }
        }
        return null;
    }

    private static boolean isDateFieldWithDeprecatedPattern(Map<?, ?> property) {
        return "date".equals(property.get("type")) && property.containsKey("format") && JodaDeprecationPatterns.isDeprecatedPattern((String)((String)property.get("format")));
    }

    static DeprecationIssue chainedMultiFieldsCheck(IndexMetadata indexMetadata) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetadata, (mappingMetadata, sourceAsMap) -> issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetadata.type(), sourceAsMap, IndexDeprecationChecks::containsChainedMultiFields, IndexDeprecationChecks::formatField)));
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Multi-fields within multi-fields", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html#_defining_multi_fields_within_multi_fields", "The names of fields that contain chained multi-fields: " + issues, false, null);
        }
        return null;
    }

    private static boolean containsChainedMultiFields(Map<?, ?> property) {
        if (property.containsKey("fields")) {
            Map fields = (Map)property.get("fields");
            for (Object rawSubField : fields.values()) {
                Map subField = (Map)rawSubField;
                if (!subField.containsKey("fields")) continue;
                return true;
            }
        }
        return false;
    }

    static DeprecationIssue fieldNamesDisabledCheck(IndexMetadata indexMetadata) {
        MappingMetadata mapping = indexMetadata.mapping();
        if (mapping != null && ClusterDeprecationChecks.mapContainsFieldNamesDisabled(mapping.getSourceAsMap())) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Index mapping contains explicit `_field_names` enabling settings.", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html#fieldnames-enabling", "The index mapping contains a deprecated `enabled` setting for `_field_names` that should be removed moving foward.", false, null);
        }
        return null;
    }

    static int countFieldsRecursively(String type, Map<String, Object> parentMap) {
        int fields = 0;
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return fields;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (valueMap.containsKey("type") && !(valueMap.get("type").equals("object") && !valueMap.containsKey("properties")) && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                ++fields;
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (multifieldValueMap.containsKey("type") && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                        ++fields;
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    fields += IndexDeprecationChecks.countFieldsRecursively(type, multifieldValueMap);
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            fields += IndexDeprecationChecks.countFieldsRecursively(type, valueMap);
        }
        return fields;
    }

    static DeprecationIssue translogRetentionSettingCheck(IndexMetadata indexMetadata) {
        boolean softDeletesEnabled = (Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexMetadata.getSettings());
        if (softDeletesEnabled && (IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(indexMetadata.getSettings()) || IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(indexMetadata.getSettings()))) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "translog retention settings are ignored", "https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules-translog.html", "translog retention settings [index.translog.retention.size] and [index.translog.retention.age] are ignored because translog is no longer used in peer recoveries with soft-deletes enabled (default in 7.0 or later)", false, null);
        }
        return null;
    }

    static DeprecationIssue checkIndexDataPath(IndexMetadata indexMetadata) {
        if (IndexMetadata.INDEX_DATA_PATH_SETTING.exists(indexMetadata.getSettings())) {
            String message = String.format(Locale.ROOT, "setting [%s] is deprecated and will be removed in a future version", IndexMetadata.INDEX_DATA_PATH_SETTING.getKey());
            String url = "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/breaking-changes-7.13.html#deprecate-shared-data-path-setting";
            String details = "Found index data path configured. Discontinue use of this setting.";
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/breaking-changes-7.13.html#deprecate-shared-data-path-setting", "Found index data path configured. Discontinue use of this setting.", false, null);
        }
        return null;
    }

    static DeprecationIssue indexingSlowLogLevelSettingCheck(IndexMetadata indexMetadata) {
        return IndexDeprecationChecks.slowLogSettingCheck(indexMetadata, (Setting<SlowLogLevel>)IndexingSlowLog.INDEX_INDEXING_SLOWLOG_LEVEL_SETTING);
    }

    static DeprecationIssue searchSlowLogLevelSettingCheck(IndexMetadata indexMetadata) {
        return IndexDeprecationChecks.slowLogSettingCheck(indexMetadata, (Setting<SlowLogLevel>)SearchSlowLog.INDEX_SEARCH_SLOWLOG_LEVEL);
    }

    private static DeprecationIssue slowLogSettingCheck(IndexMetadata indexMetadata, Setting<SlowLogLevel> setting) {
        if (setting.exists(indexMetadata.getSettings())) {
            String message = String.format(Locale.ROOT, "setting [%s] is deprecated and will be removed in a future version", setting.getKey());
            String url = "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/migrating-7.13.html#slow-log-level-removal";
            String details = String.format(Locale.ROOT, "Found [%s] configured. Discontinue use of this setting. Use thresholds.", setting.getKey());
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/migrating-7.13.html#slow-log-level-removal", details, false, null);
        }
        return null;
    }

    static DeprecationIssue storeTypeSettingCheck(IndexMetadata indexMetadata) {
        String storeType = (String)IndexModule.INDEX_STORE_TYPE_SETTING.get(indexMetadata.getSettings());
        if (IndexModule.Type.SIMPLEFS.match(storeType)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "[simplefs] is deprecated and will be removed in future versions", "https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules-store.html", "[simplefs] is deprecated and will be removed in 8.0. Use [niofs] or other file systems instead. Elasticsearch 7.15 or later uses [niofs] for the [simplefs] store type as it offers superior or equivalent performance to [simplefs].", false, null);
        }
        return null;
    }

    static {
        HashSet<String> typesThatDontCount = new HashSet<String>();
        typesThatDontCount.add("binary");
        typesThatDontCount.add("geo_point");
        typesThatDontCount.add("geo_shape");
        TYPES_THAT_DONT_COUNT = Collections.unmodifiableSet(typesThatDontCount);
    }
}

