/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.async;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.async.StoredAsyncResponse;
import org.elasticsearch.xpack.core.search.action.SearchStatusResponse;

public class QlStatusResponse
extends ActionResponse
implements SearchStatusResponse,
StatusToXContentObject {
    private final String id;
    private final boolean isRunning;
    private final boolean isPartial;
    private final Long startTimeMillis;
    private final long expirationTimeMillis;
    private final RestStatus completionStatus;

    public QlStatusResponse(String id, boolean isRunning, boolean isPartial, Long startTimeMillis, long expirationTimeMillis, RestStatus completionStatus) {
        this.id = id;
        this.isRunning = isRunning;
        this.isPartial = isPartial;
        this.startTimeMillis = startTimeMillis;
        this.expirationTimeMillis = expirationTimeMillis;
        this.completionStatus = completionStatus;
    }

    public static <S extends Writeable & AsyncStatus> QlStatusResponse getStatusFromStoredSearch(StoredAsyncResponse<S> storedResponse, long expirationTimeMillis, String id) {
        S searchResponse = storedResponse.getResponse();
        if (searchResponse != null) {
            assert (!((AsyncStatus)searchResponse).isRunning()) : "Stored Ql search response must have a completed status!";
            return new QlStatusResponse(((AsyncStatus)searchResponse).id(), false, ((AsyncStatus)searchResponse).isPartial(), null, expirationTimeMillis, RestStatus.OK);
        }
        Exception exc = storedResponse.getException();
        assert (exc != null) : "Stored Ql response must either have a search response or an exception!";
        return new QlStatusResponse(id, false, false, null, expirationTimeMillis, ExceptionsHelper.status(exc));
    }

    public QlStatusResponse(StreamInput in) throws IOException {
        this.id = in.readString();
        this.isRunning = in.readBoolean();
        this.isPartial = in.readBoolean();
        this.startTimeMillis = in.readOptionalLong();
        this.expirationTimeMillis = in.readLong();
        this.completionStatus = !this.isRunning ? RestStatus.readFrom(in) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBoolean(this.isRunning);
        out.writeBoolean(this.isPartial);
        out.writeOptionalLong(this.startTimeMillis);
        out.writeLong(this.expirationTimeMillis);
        if (!this.isRunning) {
            RestStatus.writeTo(out, this.completionStatus);
        }
    }

    @Override
    public RestStatus status() {
        return RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("is_running", this.isRunning);
        builder.field("is_partial", this.isPartial);
        if (this.startTimeMillis != null) {
            builder.timeField("start_time_in_millis", "start_time", this.startTimeMillis);
        }
        builder.timeField("expiration_time_in_millis", "expiration_time", this.expirationTimeMillis);
        if (!this.isRunning) {
            builder.field("completion_status", this.completionStatus.getStatus());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QlStatusResponse other = (QlStatusResponse)obj;
        return this.id.equals(other.id) && this.isRunning == other.isRunning && this.isPartial == other.isPartial && Objects.equals(this.startTimeMillis, other.startTimeMillis) && this.expirationTimeMillis == other.expirationTimeMillis && Objects.equals((Object)this.completionStatus, (Object)other.completionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.isRunning, this.isPartial, this.startTimeMillis, this.expirationTimeMillis, this.completionStatus});
    }

    public String getId() {
        return this.id;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public Long getStartTime() {
        return this.startTimeMillis;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTimeMillis;
    }

    public RestStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public static interface AsyncStatus {
        public String id();

        public boolean isRunning();

        public boolean isPartial();
    }
}

