/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class WatcherFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final Map<String, Object> stats;

    public WatcherFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.stats = in.readMap();
    }

    public WatcherFeatureSetUsage(boolean available, boolean enabled, Map<String, Object> stats) {
        super("watcher", available, enabled);
        this.stats = stats;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_6_0_0;
    }

    public Map<String, Object> stats() {
        return this.stats;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.enabled) {
            for (Map.Entry<String, Object> entry : this.stats.entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.stats);
    }
}

