/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

public class GetTransformAction
extends ActionType<Response> {
    public static final GetTransformAction INSTANCE = new GetTransformAction();
    public static final String NAME = "cluster:monitor/transform/get";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(GetTransformAction.class);

    private GetTransformAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<TransformConfig>
    implements Writeable,
    ToXContentObject {
        public static final String INVALID_TRANSFORMS_DEPRECATION_WARNING = "Found [{}] invalid transforms";
        private static final ParseField INVALID_TRANSFORMS = new ParseField("invalid_transforms", new String[0]);

        public Response(List<TransformConfig> transformConfigs, long count) {
            super(new QueryPage<TransformConfig>(transformConfigs, count, TransformField.TRANSFORMS));
        }

        public Response() {
        }

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public List<TransformConfig> getTransformConfigurations() {
            return this.getResources().results();
        }

        public long getCount() {
            return this.getResources().count();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            ArrayList<String> invalidTransforms = new ArrayList<String>();
            builder.startObject();
            builder.field(TransformField.COUNT.getPreferredName(), this.getResources().count());
            builder.field(TransformField.TRANSFORMS.getPreferredName());
            builder.startArray();
            for (TransformConfig configResponse : this.getResources().results()) {
                configResponse.toXContent(builder, params);
                ActionRequestValidationException validationException = configResponse.validate(null);
                if (validationException == null) continue;
                invalidTransforms.add(configResponse.getId());
            }
            builder.endArray();
            if (!invalidTransforms.isEmpty()) {
                builder.startObject(INVALID_TRANSFORMS.getPreferredName());
                builder.field(TransformField.COUNT.getPreferredName(), invalidTransforms.size());
                builder.field(TransformField.TRANSFORMS.getPreferredName(), invalidTransforms);
                builder.endObject();
                deprecationLogger.deprecate(DeprecationCategory.OTHER, "invalid_transforms", INVALID_TRANSFORMS_DEPRECATION_WARNING, invalidTransforms.size());
            }
            builder.endObject();
            return builder;
        }

        @Override
        protected Writeable.Reader<TransformConfig> getReader() {
            return TransformConfig::new;
        }
    }

    public static class Request
    extends AbstractGetResourcesRequest {
        private static final int MAX_SIZE_RETURN = 1000;

        public Request(String id) {
            super(id, PageParams.defaultParams(), true);
        }

        public Request() {
            super(null, PageParams.defaultParams(), true);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public String getId() {
            return this.getResourceId();
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException exception = null;
            if (this.getPageParams() != null && this.getPageParams().getSize() > 1000) {
                exception = ValidateActions.addValidationError("Param [" + PageParams.SIZE.getPreferredName() + "] has a max acceptable value of [" + 1000 + "]", exception);
            }
            return exception;
        }

        @Override
        public String getResourceIdField() {
            return TransformField.ID.getPreferredName();
        }
    }
}

