/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.pki;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.security.authc.support.mapper.CompositeRoleMapperSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public final class PkiRealmSettings {
    public static final String TYPE = "pki";
    public static final String DEFAULT_USERNAME_PATTERN = "CN=(.*?)(?:,|$)";
    public static final Setting.AffixSetting<Pattern> USERNAME_PATTERN_SETTING = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("pki"), "username_pattern", key -> new Setting<Pattern>((String)key, DEFAULT_USERNAME_PATTERN, s -> Pattern.compile(s, 2), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    private static final TimeValue DEFAULT_TTL = TimeValue.timeValueMinutes(20L);
    public static final Setting.AffixSetting<TimeValue> CACHE_TTL_SETTING = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("pki"), "cache.ttl", key -> Setting.timeSetting(key, DEFAULT_TTL, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    private static final int DEFAULT_MAX_USERS = 100000;
    public static final Setting.AffixSetting<Integer> CACHE_MAX_USERS_SETTING = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("pki"), "cache.max_users", key -> Setting.intSetting(key, 100000, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> DELEGATION_ENABLED_SETTING = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("pki"), "delegation.enabled", key -> Setting.boolSetting(key, false, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Optional<String>> TRUST_STORE_PATH;
    public static final Setting.AffixSetting<Optional<String>> TRUST_STORE_TYPE;
    public static final Setting.AffixSetting<SecureString> TRUST_STORE_PASSWORD;
    public static final Setting.AffixSetting<SecureString> LEGACY_TRUST_STORE_PASSWORD;
    public static final Setting.AffixSetting<String> TRUST_STORE_ALGORITHM;
    public static final Setting.AffixSetting<List<String>> CAPATH_SETTING;

    private PkiRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.add(USERNAME_PATTERN_SETTING);
        settings.add(CACHE_TTL_SETTING);
        settings.add(CACHE_MAX_USERS_SETTING);
        settings.add(DELEGATION_ENABLED_SETTING);
        settings.add(TRUST_STORE_PATH);
        settings.add(TRUST_STORE_PASSWORD);
        settings.add(LEGACY_TRUST_STORE_PASSWORD);
        settings.add(TRUST_STORE_ALGORITHM);
        settings.add(CAPATH_SETTING);
        settings.addAll(DelegatedAuthorizationSettings.getSettings(TYPE));
        settings.addAll(CompositeRoleMapperSettings.getSettings(TYPE));
        settings.addAll(RealmSettings.getStandardSettings(TYPE));
        return settings;
    }

    static {
        String prefix = "xpack.security.authc.realms.pki.";
        SSLConfigurationSettings ssl = SSLConfigurationSettings.withoutPrefix();
        TRUST_STORE_PATH = Setting.affixKeySetting("xpack.security.authc.realms.pki.", ssl.truststorePath.getKey(), SSLConfigurationSettings.TRUST_STORE_PATH_TEMPLATE, new Setting.AffixSettingDependency[0]);
        TRUST_STORE_TYPE = Setting.affixKeySetting("xpack.security.authc.realms.pki.", ssl.truststoreType.getKey(), SSLConfigurationSettings.TRUST_STORE_TYPE_TEMPLATE, new Setting.AffixSettingDependency[0]);
        TRUST_STORE_PASSWORD = Setting.affixKeySetting("xpack.security.authc.realms.pki.", ssl.truststorePassword.getKey(), SSLConfigurationSettings.TRUSTSTORE_PASSWORD_TEMPLATE, new Setting.AffixSettingDependency[0]);
        LEGACY_TRUST_STORE_PASSWORD = Setting.affixKeySetting("xpack.security.authc.realms.pki.", ssl.legacyTruststorePassword.getKey(), SSLConfigurationSettings.LEGACY_TRUSTSTORE_PASSWORD_TEMPLATE, new Setting.AffixSettingDependency[0]);
        TRUST_STORE_ALGORITHM = Setting.affixKeySetting("xpack.security.authc.realms.pki.", ssl.truststoreAlgorithm.getKey(), SSLConfigurationSettings.TRUST_STORE_ALGORITHM_TEMPLATE, new Setting.AffixSettingDependency[0]);
        CAPATH_SETTING = Setting.affixKeySetting("xpack.security.authc.realms.pki.", ssl.caPaths.getKey(), SSLConfigurationSettings.CAPATH_SETTING_TEMPLATE, new Setting.AffixSettingDependency[0]);
    }
}

