/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CreateServiceAccountTokenResponse
extends ActionResponse
implements ToXContentObject {
    private final String name;
    private final SecureString value;

    private CreateServiceAccountTokenResponse(String name, SecureString value) {
        this.name = name;
        this.value = value;
    }

    public CreateServiceAccountTokenResponse(StreamInput in) throws IOException {
        super(in);
        this.name = in.readOptionalString();
        this.value = in.readOptionalSecureString();
    }

    public String getName() {
        return this.name;
    }

    public SecureString getValue() {
        return this.value;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("created", true).field("token").startObject().field("name", this.name).field("value", this.value.toString()).endObject().endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        out.writeOptionalSecureString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateServiceAccountTokenResponse that = (CreateServiceAccountTokenResponse)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static CreateServiceAccountTokenResponse created(String name, SecureString value) {
        return new CreateServiceAccountTokenResponse(name, value);
    }
}

