/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rest.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public class RestXPackInfoAction
extends XPackRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_xpack"), new RestHandler.Route(RestRequest.Method.HEAD, "/_xpack")));
    }

    @Override
    public String getName() {
        return "xpack_info_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        boolean verbose = request.paramAsBoolean("human", true);
        boolean acceptEnterprise = request.paramAsBoolean("accept_enterprise", false);
        int licenseVersion = acceptEnterprise ? 5 : 4;
        EnumSet<XPackInfoRequest.Category> categories = XPackInfoRequest.Category.toSet(request.paramAsStringArray("categories", new String[]{"_all"}));
        return channel -> client.prepareInfo().setVerbose(verbose).setCategories(categories).setLicenseVersion(licenseVersion).execute(new RestToXContentListener((RestChannel)channel));
    }
}

