/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Bucket
implements ToXContentObject,
Writeable {
    private static final ParseField JOB_ID = Job.ID;
    public static final ParseField ANOMALY_SCORE = new ParseField("anomaly_score", new String[0]);
    public static final ParseField INITIAL_ANOMALY_SCORE = new ParseField("initial_anomaly_score", new String[0]);
    public static final ParseField EVENT_COUNT = new ParseField("event_count", new String[0]);
    public static final ParseField RECORDS = new ParseField("records", new String[0]);
    public static final ParseField BUCKET_INFLUENCERS = new ParseField("bucket_influencers", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField PROCESSING_TIME_MS = new ParseField("processing_time_ms", new String[0]);
    public static final ParseField SCHEDULED_EVENTS = new ParseField("scheduled_events", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("buckets", new String[0]);
    public static final String RESULT_TYPE_VALUE = "bucket";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("bucket", new String[0]);
    public static final ConstructingObjectParser<Bucket, Void> STRICT_PARSER = Bucket.createParser(false);
    public static final ConstructingObjectParser<Bucket, Void> LENIENT_PARSER = Bucket.createParser(true);
    private final String jobId;
    private final Date timestamp;
    private final long bucketSpan;
    private double anomalyScore;
    private double initialAnomalyScore;
    private List<AnomalyRecord> records = new ArrayList<AnomalyRecord>();
    private long eventCount;
    private boolean isInterim;
    private List<BucketInfluencer> bucketInfluencers = new ArrayList<BucketInfluencer>();
    private long processingTimeMs;
    private List<String> scheduledEvents = Collections.emptyList();

    public static Bucket readOldPerPartitionNormalization(StreamInput in) throws IOException {
        in.readString();
        in.readString();
        in.readDouble();
        in.readDouble();
        in.readDouble();
        return null;
    }

    private static ConstructingObjectParser<Bucket, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<Bucket, Void> parser = new ConstructingObjectParser<Bucket, Void>(RESULT_TYPE_VALUE, ignoreUnknownFields, a -> new Bucket((String)a[0], (Date)a[1], (Long)a[2]));
        parser.declareString(ConstructingObjectParser.constructorArg(), JOB_ID);
        parser.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeField(p, Result.TIMESTAMP.getPreferredName()), Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        parser.declareDouble(Bucket::setAnomalyScore, ANOMALY_SCORE);
        parser.declareDouble(Bucket::setInitialAnomalyScore, INITIAL_ANOMALY_SCORE);
        parser.declareBoolean(Bucket::setInterim, Result.IS_INTERIM);
        parser.declareLong(Bucket::setEventCount, EVENT_COUNT);
        parser.declareObjectArray(Bucket::setRecords, ignoreUnknownFields ? AnomalyRecord.LENIENT_PARSER : AnomalyRecord.STRICT_PARSER, RECORDS);
        parser.declareObjectArray(Bucket::setBucketInfluencers, ignoreUnknownFields ? BucketInfluencer.LENIENT_PARSER : BucketInfluencer.STRICT_PARSER, BUCKET_INFLUENCERS);
        parser.declareLong(Bucket::setProcessingTimeMs, PROCESSING_TIME_MS);
        parser.declareString((bucket, s) -> {}, Result.RESULT_TYPE);
        parser.declareStringArray(Bucket::setScheduledEvents, SCHEDULED_EVENTS);
        return parser;
    }

    public Bucket(String jobId, Date timestamp, long bucketSpan) {
        this.jobId = jobId;
        this.timestamp = ExceptionsHelper.requireNonNull(timestamp, Result.TIMESTAMP.getPreferredName());
        this.bucketSpan = bucketSpan;
    }

    public Bucket(Bucket other) {
        this.jobId = other.jobId;
        this.timestamp = other.timestamp;
        this.bucketSpan = other.bucketSpan;
        this.anomalyScore = other.anomalyScore;
        this.initialAnomalyScore = other.initialAnomalyScore;
        this.records = new ArrayList<AnomalyRecord>(other.records);
        this.eventCount = other.eventCount;
        this.isInterim = other.isInterim;
        this.bucketInfluencers = new ArrayList<BucketInfluencer>(other.bucketInfluencers);
        this.processingTimeMs = other.processingTimeMs;
        this.scheduledEvents = new ArrayList<String>(other.scheduledEvents);
    }

    public Bucket(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = new Date(in.readLong());
        this.anomalyScore = in.readDouble();
        this.bucketSpan = in.readLong();
        this.initialAnomalyScore = in.readDouble();
        this.records = in.readList(AnomalyRecord::new);
        this.eventCount = in.readLong();
        this.isInterim = in.readBoolean();
        this.bucketInfluencers = in.readList(BucketInfluencer::new);
        this.processingTimeMs = in.readLong();
        if (in.getVersion().before(Version.V_6_5_0)) {
            in.readList(Bucket::readOldPerPartitionNormalization);
        }
        if (in.getVersion().onOrAfter(Version.V_6_2_0)) {
            this.scheduledEvents = in.readStringList();
            if (this.scheduledEvents.isEmpty()) {
                this.scheduledEvents = Collections.emptyList();
            }
        } else {
            this.scheduledEvents = Collections.emptyList();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeLong(this.timestamp.getTime());
        out.writeDouble(this.anomalyScore);
        out.writeLong(this.bucketSpan);
        out.writeDouble(this.initialAnomalyScore);
        out.writeList(this.records);
        out.writeLong(this.eventCount);
        out.writeBoolean(this.isInterim);
        out.writeList(this.bucketInfluencers);
        out.writeLong(this.processingTimeMs);
        if (out.getVersion().before(Version.V_6_5_0)) {
            out.writeList(Collections.emptyList());
        }
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeStringCollection(this.scheduledEvents);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(JOB_ID.getPreferredName(), this.jobId);
        builder.timeField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        builder.field(ANOMALY_SCORE.getPreferredName(), this.anomalyScore);
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(INITIAL_ANOMALY_SCORE.getPreferredName(), this.initialAnomalyScore);
        if (!this.records.isEmpty()) {
            builder.field(RECORDS.getPreferredName(), this.records);
        }
        builder.field(EVENT_COUNT.getPreferredName(), this.eventCount);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.field(BUCKET_INFLUENCERS.getPreferredName(), this.bucketInfluencers);
        builder.field(PROCESSING_TIME_MS.getPreferredName(), this.processingTimeMs);
        if (!this.scheduledEvents.isEmpty()) {
            builder.field(SCHEDULED_EVENTS.getPreferredName(), this.scheduledEvents);
        }
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getId() {
        return this.jobId + "_bucket_" + this.timestamp.getTime() + "_" + this.bucketSpan;
    }

    public long getEpoch() {
        return this.timestamp.getTime() / 1000L;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public double getAnomalyScore() {
        return this.anomalyScore;
    }

    public void setAnomalyScore(double anomalyScore) {
        this.anomalyScore = anomalyScore;
    }

    public double getInitialAnomalyScore() {
        return this.initialAnomalyScore;
    }

    public void setInitialAnomalyScore(double initialAnomalyScore) {
        this.initialAnomalyScore = initialAnomalyScore;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public List<AnomalyRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<AnomalyRecord> records) {
        this.records = Objects.requireNonNull(records);
    }

    public long getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(long value) {
        this.eventCount = value;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public void setInterim(boolean isInterim) {
        this.isInterim = isInterim;
    }

    public long getProcessingTimeMs() {
        return this.processingTimeMs;
    }

    public void setProcessingTimeMs(long timeMs) {
        this.processingTimeMs = timeMs;
    }

    public List<BucketInfluencer> getBucketInfluencers() {
        return this.bucketInfluencers;
    }

    public void setBucketInfluencers(List<BucketInfluencer> bucketInfluencers) {
        this.bucketInfluencers = Objects.requireNonNull(bucketInfluencers);
    }

    public void addBucketInfluencer(BucketInfluencer bucketInfluencer) {
        this.bucketInfluencers.add(bucketInfluencer);
    }

    public List<String> getScheduledEvents() {
        return this.scheduledEvents;
    }

    public void setScheduledEvents(List<String> scheduledEvents) {
        this.scheduledEvents = ExceptionsHelper.requireNonNull(scheduledEvents, SCHEDULED_EVENTS.getPreferredName());
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.eventCount, this.initialAnomalyScore, this.anomalyScore, this.records, this.isInterim, this.bucketSpan, this.bucketInfluencers, this.processingTimeMs, this.scheduledEvents);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bucket)) {
            return false;
        }
        Bucket that = (Bucket)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && this.eventCount == that.eventCount && this.bucketSpan == that.bucketSpan && this.anomalyScore == that.anomalyScore && this.initialAnomalyScore == that.initialAnomalyScore && Objects.equals(this.records, that.records) && Objects.equals(this.isInterim, that.isInterim) && Objects.equals(this.bucketInfluencers, that.bucketInfluencers) && this.processingTimeMs == that.processingTimeMs && Objects.equals(this.scheduledEvents, that.scheduledEvents);
    }

    public boolean isNormalizable() {
        return this.anomalyScore > 0.0;
    }
}

