/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.classification;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.dataframe.stats.AnalysisStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.Fields;
import org.elasticsearch.xpack.core.ml.dataframe.stats.classification.Hyperparameters;
import org.elasticsearch.xpack.core.ml.dataframe.stats.classification.TimingStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.classification.ValidationLoss;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class ClassificationStats
implements AnalysisStats {
    public static final String TYPE_VALUE = "classification_stats";
    public static final ParseField ITERATION = new ParseField("iteration", new String[0]);
    public static final ParseField HYPERPARAMETERS = new ParseField("hyperparameters", new String[0]);
    public static final ParseField TIMING_STATS = new ParseField("timing_stats", new String[0]);
    public static final ParseField VALIDATION_LOSS = new ParseField("validation_loss", new String[0]);
    public static final ConstructingObjectParser<ClassificationStats, Void> STRICT_PARSER = ClassificationStats.createParser(false);
    public static final ConstructingObjectParser<ClassificationStats, Void> LENIENT_PARSER = ClassificationStats.createParser(true);
    private final String jobId;
    private final Instant timestamp;
    private final int iteration;
    private final Hyperparameters hyperparameters;
    private final TimingStats timingStats;
    private final ValidationLoss validationLoss;

    private static ConstructingObjectParser<ClassificationStats, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<ClassificationStats, Void> parser = new ConstructingObjectParser<ClassificationStats, Void>(TYPE_VALUE, ignoreUnknownFields, a -> new ClassificationStats((String)a[0], (Instant)a[1], (Integer)a[2], (Hyperparameters)a[3], (TimingStats)a[4], (ValidationLoss)a[5]));
        parser.declareString((bucket, s) -> {}, Fields.TYPE);
        parser.declareString(ConstructingObjectParser.constructorArg(), Fields.JOB_ID);
        parser.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, Fields.TIMESTAMP.getPreferredName()), Fields.TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareInt(ConstructingObjectParser.constructorArg(), ITERATION);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Hyperparameters.fromXContent(p, ignoreUnknownFields), HYPERPARAMETERS);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> TimingStats.fromXContent(p, ignoreUnknownFields), TIMING_STATS);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ValidationLoss.fromXContent(p, ignoreUnknownFields), VALIDATION_LOSS);
        return parser;
    }

    public ClassificationStats(String jobId, Instant timestamp, int iteration, Hyperparameters hyperparameters, TimingStats timingStats, ValidationLoss validationLoss) {
        this.jobId = Objects.requireNonNull(jobId);
        this.timestamp = Instant.ofEpochMilli(ExceptionsHelper.requireNonNull(timestamp, Fields.TIMESTAMP).toEpochMilli());
        this.iteration = iteration;
        this.hyperparameters = Objects.requireNonNull(hyperparameters);
        this.timingStats = Objects.requireNonNull(timingStats);
        this.validationLoss = Objects.requireNonNull(validationLoss);
    }

    public ClassificationStats(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = in.readInstant();
        this.iteration = in.readVInt();
        this.hyperparameters = new Hyperparameters(in);
        this.timingStats = new TimingStats(in);
        this.validationLoss = new ValidationLoss(in);
    }

    @Override
    public String getWriteableName() {
        return TYPE_VALUE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeInstant(this.timestamp);
        out.writeVInt(this.iteration);
        this.hyperparameters.writeTo(out);
        this.timingStats.writeTo(out);
        this.validationLoss.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(Fields.TYPE.getPreferredName(), TYPE_VALUE);
            builder.field(Fields.JOB_ID.getPreferredName(), this.jobId);
        }
        builder.timeField(Fields.TIMESTAMP.getPreferredName(), Fields.TIMESTAMP.getPreferredName() + "_string", this.timestamp.toEpochMilli());
        builder.field(ITERATION.getPreferredName(), this.iteration);
        builder.field(HYPERPARAMETERS.getPreferredName(), this.hyperparameters);
        builder.field(TIMING_STATS.getPreferredName(), this.timingStats);
        builder.field(VALIDATION_LOSS.getPreferredName(), this.validationLoss, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationStats that = (ClassificationStats)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && this.iteration == that.iteration && Objects.equals(this.hyperparameters, that.hyperparameters) && Objects.equals(this.timingStats, that.timingStats) && Objects.equals(this.validationLoss, that.validationLoss);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.iteration, this.hyperparameters, this.timingStats, this.validationLoss);
    }

    public String documentId(String jobId) {
        return ClassificationStats.documentIdPrefix(jobId) + this.timestamp.toEpochMilli();
    }

    public static String documentIdPrefix(String jobId) {
        return "classification_stats_" + jobId + "_";
    }
}

