/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.common.time.TimeUtils;

public class DelayedDataCheckConfig
implements ToXContentObject,
Writeable {
    public static final TimeValue MAX_DELAYED_DATA_WINDOW = TimeValue.timeValueHours(24L);
    public static final int MAX_NUMBER_SPANABLE_BUCKETS = 10000;
    public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    public static final ParseField CHECK_WINDOW = new ParseField("check_window", new String[0]);
    public static final ConstructingObjectParser<DelayedDataCheckConfig, Void> LENIENT_PARSER = DelayedDataCheckConfig.createParser(true);
    public static final ConstructingObjectParser<DelayedDataCheckConfig, Void> STRICT_PARSER = DelayedDataCheckConfig.createParser(false);
    private final boolean enabled;
    private final TimeValue checkWindow;

    private static ConstructingObjectParser<DelayedDataCheckConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<DelayedDataCheckConfig, Void> parser = new ConstructingObjectParser<DelayedDataCheckConfig, Void>("delayed_data_check_config", ignoreUnknownFields, a -> new DelayedDataCheckConfig((Boolean)a[0], (TimeValue)a[1]));
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), text -> TimeValue.parseTimeValue(text, CHECK_WINDOW.getPreferredName()), CHECK_WINDOW);
        return parser;
    }

    public static DelayedDataCheckConfig defaultDelayedDataCheckConfig() {
        return new DelayedDataCheckConfig(true, null);
    }

    public static DelayedDataCheckConfig enabledDelayedDataCheckConfig(TimeValue timeValue) {
        return new DelayedDataCheckConfig(true, timeValue);
    }

    public static DelayedDataCheckConfig disabledDelayedDataCheckConfig() {
        return new DelayedDataCheckConfig(false, null);
    }

    DelayedDataCheckConfig(Boolean enabled, TimeValue checkWindow) {
        this.enabled = enabled;
        if (enabled.booleanValue() && checkWindow != null) {
            TimeUtils.checkPositive(checkWindow, CHECK_WINDOW);
            if (checkWindow.compareTo(MAX_DELAYED_DATA_WINDOW) > 0) {
                throw new IllegalArgumentException("check_window [" + checkWindow.getStringRep() + "] must be less than or equal to [24h]");
            }
        }
        this.checkWindow = checkWindow;
    }

    public DelayedDataCheckConfig(StreamInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.checkWindow = in.readOptionalTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeOptionalTimeValue(this.checkWindow);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public TimeValue getCheckWindow() {
        return this.checkWindow;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED.getPreferredName(), this.enabled);
        if (this.checkWindow != null) {
            builder.field(CHECK_WINDOW.getPreferredName(), this.checkWindow.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.checkWindow);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DelayedDataCheckConfig other = (DelayedDataCheckConfig)obj;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.checkWindow, other.checkWindow);
    }
}

