/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ClassificationConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ClassificationConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfigUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class InternalInferModelAction
extends ActionType<Response> {
    public static final InternalInferModelAction INSTANCE = new InternalInferModelAction();
    public static final String NAME = "cluster:internal/xpack/ml/inference/infer";

    private InternalInferModelAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse {
        private final List<InferenceResults> inferenceResults;
        private final String modelId;
        private final boolean isLicensed;

        public Response(List<InferenceResults> inferenceResults, String modelId, boolean isLicensed) {
            this.inferenceResults = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(inferenceResults, "inferenceResults"));
            this.isLicensed = isLicensed;
            this.modelId = modelId;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.inferenceResults = Collections.unmodifiableList(in.readNamedWriteableList(InferenceResults.class));
            this.isLicensed = in.readBoolean();
            this.modelId = in.getVersion().onOrAfter(Version.V_7_13_0) ? in.readOptionalString() : null;
        }

        public List<InferenceResults> getInferenceResults() {
            return this.inferenceResults;
        }

        public boolean isLicensed() {
            return this.isLicensed;
        }

        public String getModelId() {
            return this.modelId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeNamedWriteableList(this.inferenceResults);
            out.writeBoolean(this.isLicensed);
            if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
                out.writeOptionalString(this.modelId);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)o;
            return this.isLicensed == that.isLicensed && Objects.equals(this.inferenceResults, that.inferenceResults) && Objects.equals(this.modelId, that.modelId);
        }

        public int hashCode() {
            return Objects.hash(this.inferenceResults, this.isLicensed, this.modelId);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private List<InferenceResults> inferenceResults;
            private String modelId;
            private boolean isLicensed;

            public Builder setInferenceResults(List<InferenceResults> inferenceResults) {
                this.inferenceResults = inferenceResults;
                return this;
            }

            public Builder setLicensed(boolean licensed) {
                this.isLicensed = licensed;
                return this;
            }

            public Builder setModelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public Response build() {
                return new Response(this.inferenceResults, this.modelId, this.isLicensed);
            }
        }
    }

    public static class Request
    extends ActionRequest {
        private final String modelId;
        private final List<Map<String, Object>> objectsToInfer;
        private final InferenceConfigUpdate update;
        private final boolean previouslyLicensed;

        public Request(String modelId, boolean previouslyLicensed) {
            this(modelId, Collections.emptyList(), (InferenceConfigUpdate)RegressionConfigUpdate.EMPTY_PARAMS, previouslyLicensed);
        }

        public Request(String modelId, List<Map<String, Object>> objectsToInfer, InferenceConfigUpdate inferenceConfig, boolean previouslyLicensed) {
            this.modelId = ExceptionsHelper.requireNonNull(modelId, TrainedModelConfig.MODEL_ID);
            this.objectsToInfer = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(objectsToInfer, "objects_to_infer"));
            this.update = ExceptionsHelper.requireNonNull(inferenceConfig, "inference_config");
            this.previouslyLicensed = previouslyLicensed;
        }

        public Request(String modelId, Map<String, Object> objectToInfer, InferenceConfigUpdate update, boolean previouslyLicensed) {
            this(modelId, Collections.singletonList(ExceptionsHelper.requireNonNull(objectToInfer, "objects_to_infer")), update, previouslyLicensed);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.objectsToInfer = Collections.unmodifiableList(in.readList(StreamInput::readMap));
            if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
                this.update = in.readNamedWriteable(InferenceConfigUpdate.class);
            } else {
                InferenceConfig oldConfig = in.readNamedWriteable(InferenceConfig.class);
                if (oldConfig instanceof RegressionConfig) {
                    this.update = RegressionConfigUpdate.fromConfig((RegressionConfig)oldConfig);
                } else if (oldConfig instanceof ClassificationConfig) {
                    this.update = ClassificationConfigUpdate.fromConfig((ClassificationConfig)oldConfig);
                } else {
                    throw new IOException("Unexpected configuration type [" + oldConfig.getName() + "]");
                }
            }
            this.previouslyLicensed = in.readBoolean();
        }

        public String getModelId() {
            return this.modelId;
        }

        public List<Map<String, Object>> getObjectsToInfer() {
            return this.objectsToInfer;
        }

        public InferenceConfigUpdate getUpdate() {
            return this.update;
        }

        public boolean isPreviouslyLicensed() {
            return this.previouslyLicensed;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            out.writeCollection(this.objectsToInfer, StreamOutput::writeMap);
            if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
                out.writeNamedWriteable(this.update);
            } else if (this.update instanceof RegressionConfigUpdate || this.update instanceof ClassificationConfigUpdate) {
                out.writeNamedWriteable(this.update.toConfig());
            } else {
                throw new UnsupportedOperationException("inference config of type [" + this.update.getName() + "] cannot be serialized to node of version [" + out.getVersion() + "]");
            }
            out.writeBoolean(this.previouslyLicensed);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.update, that.update) && Objects.equals(this.previouslyLicensed, that.previouslyLicensed) && Objects.equals(this.objectsToInfer, that.objectsToInfer);
        }

        public int hashCode() {
            return Objects.hash(this.modelId, this.objectsToInfer, this.update, this.previouslyLicensed);
        }

        @Override
        public String toString() {
            return "Request{modelId='" + this.modelId + '\'' + ", objectsToInfer=" + this.objectsToInfer + ", update=" + this.update + ", previouslyLicensed=" + this.previouslyLicensed + '}';
        }
    }
}

