/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexing;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContentObject;

public abstract class IndexerJobStats
implements ToXContentObject,
Writeable {
    public static final ParseField NAME = new ParseField("job_stats", new String[0]);
    protected long numPages = 0L;
    protected long numInputDocuments = 0L;
    protected long numOuputDocuments = 0L;
    protected long numInvocations = 0L;
    protected long indexTime = 0L;
    protected long searchTime = 0L;
    protected long indexTotal = 0L;
    protected long searchTotal = 0L;
    protected long processingTime = 0L;
    protected long processingTotal = 0L;
    protected long indexFailures = 0L;
    protected long searchFailures = 0L;
    private long startIndexTime;
    private long startSearchTime;
    private long startProcessingTime;

    public IndexerJobStats() {
    }

    public IndexerJobStats(long numPages, long numInputDocuments, long numOuputDocuments, long numInvocations, long indexTime, long searchTime, long processingTime, long indexTotal, long searchTotal, long processingTotal, long indexFailures, long searchFailures) {
        this.numPages = numPages;
        this.numInputDocuments = numInputDocuments;
        this.numOuputDocuments = numOuputDocuments;
        this.numInvocations = numInvocations;
        this.indexTime = indexTime;
        this.searchTime = searchTime;
        this.processingTime = processingTime;
        this.indexTotal = indexTotal;
        this.searchTotal = searchTotal;
        this.processingTotal = processingTotal;
        this.indexFailures = indexFailures;
        this.searchFailures = searchFailures;
    }

    public IndexerJobStats(StreamInput in) throws IOException {
        this.numPages = in.readVLong();
        this.numInputDocuments = in.readVLong();
        this.numOuputDocuments = in.readVLong();
        this.numInvocations = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.indexTime = in.readVLong();
            this.searchTime = in.readVLong();
            this.indexTotal = in.readVLong();
            this.searchTotal = in.readVLong();
            this.indexFailures = in.readVLong();
            this.searchFailures = in.readVLong();
            if (in.getVersion().onOrAfter(Version.V_7_7_0)) {
                this.processingTime = in.readVLong();
                this.processingTotal = in.readVLong();
            }
        }
    }

    public long getNumPages() {
        return this.numPages;
    }

    public long getNumDocuments() {
        return this.numInputDocuments;
    }

    public long getNumInvocations() {
        return this.numInvocations;
    }

    public long getOutputDocuments() {
        return this.numOuputDocuments;
    }

    public long getIndexFailures() {
        return this.indexFailures;
    }

    public long getSearchFailures() {
        return this.searchFailures;
    }

    public long getIndexTime() {
        return this.indexTime;
    }

    public long getSearchTime() {
        return this.searchTime;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getIndexTotal() {
        return this.indexTotal;
    }

    public long getSearchTotal() {
        return this.searchTotal;
    }

    public long getProcessingTotal() {
        return this.processingTotal;
    }

    public void incrementNumPages(long n) {
        assert (n >= 0L);
        this.numPages += n;
    }

    public void incrementNumDocuments(long n) {
        assert (n >= 0L);
        this.numInputDocuments += n;
    }

    public void incrementNumInvocations(long n) {
        assert (n >= 0L);
        this.numInvocations += n;
    }

    public void incrementNumOutputDocuments(long n) {
        assert (n >= 0L);
        this.numOuputDocuments += n;
    }

    public void incrementIndexingFailures() {
        ++this.indexFailures;
    }

    public void incrementSearchFailures() {
        ++this.searchFailures;
    }

    public void markStartIndexing() {
        this.startIndexTime = System.nanoTime();
    }

    public void markEndIndexing() {
        this.indexTime += (System.nanoTime() - this.startIndexTime) / 1000000L;
        ++this.indexTotal;
    }

    public void markStartSearch() {
        this.startSearchTime = System.nanoTime();
    }

    public void markEndSearch() {
        this.searchTime += (System.nanoTime() - this.startSearchTime) / 1000000L;
        ++this.searchTotal;
    }

    public void markStartProcessing() {
        this.startProcessingTime = System.nanoTime();
    }

    public void markEndProcessing() {
        this.processingTime += (System.nanoTime() - this.startProcessingTime) / 1000000L;
        ++this.processingTotal;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.numPages);
        out.writeVLong(this.numInputDocuments);
        out.writeVLong(this.numOuputDocuments);
        out.writeVLong(this.numInvocations);
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeVLong(this.indexTime);
            out.writeVLong(this.searchTime);
            out.writeVLong(this.indexTotal);
            out.writeVLong(this.searchTotal);
            out.writeVLong(this.indexFailures);
            out.writeVLong(this.searchFailures);
        }
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeVLong(this.processingTime);
            out.writeVLong(this.processingTotal);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IndexerJobStats that = (IndexerJobStats)other;
        return Objects.equals(this.numPages, that.numPages) && Objects.equals(this.numInputDocuments, that.numInputDocuments) && Objects.equals(this.numOuputDocuments, that.numOuputDocuments) && Objects.equals(this.numInvocations, that.numInvocations) && Objects.equals(this.indexTime, that.indexTime) && Objects.equals(this.searchTime, that.searchTime) && Objects.equals(this.processingTime, that.processingTime) && Objects.equals(this.indexFailures, that.indexFailures) && Objects.equals(this.searchFailures, that.searchFailures) && Objects.equals(this.indexTotal, that.indexTotal) && Objects.equals(this.searchTotal, that.searchTotal) && Objects.equals(this.processingTotal, that.processingTotal);
    }

    public int hashCode() {
        return Objects.hash(this.numPages, this.numInputDocuments, this.numOuputDocuments, this.numInvocations, this.indexTime, this.searchTime, this.processingTime, this.indexFailures, this.searchFailures, this.indexTotal, this.searchTotal, this.processingTotal);
    }
}

