/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.DocBasedScript;
import org.elasticsearch.script.DocValuesDocReader;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.script.ScriptCache;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public abstract class AbstractFieldScript
extends DocBasedScript {
    public static final int MAX_VALUES = 100;
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = org.elasticsearch.core.Map.of("_source", value -> ((SourceLookup)value).source());
    protected final String fieldName;
    protected final SourceLookup sourceLookup;
    private final Map<String, Object> params;

    static <F> ScriptContext<F> newContext(String name, Class<F> factoryClass) {
        return new ScriptContext<F>(name, factoryClass, 100, TimeValue.timeValueMillis(0L), ScriptCache.UNLIMITED_COMPILATION_RATE.asTuple(), false);
    }

    public AbstractFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, LeafReaderContext ctx) {
        super(new DocValuesDocReader(searchLookup, ctx));
        this.fieldName = fieldName;
        Map<String, Object> docAsMap = this.docAsMap();
        this.sourceLookup = (SourceLookup)docAsMap.get("_source");
        params = new HashMap<String, Object>(params);
        params.put("_source", this.sourceLookup);
        params.put("_fields", docAsMap.get("_fields"));
        this.params = new DynamicMap(params, PARAMS_FUNCTIONS);
    }

    public final Map<String, Object> getParams() {
        return this.params;
    }

    protected List<Object> extractFromSource(String path) {
        return XContentMapValues.extractRawValues(path, this.sourceLookup.source());
    }

    protected final void emitFromCompositeScript(CompositeFieldScript compositeFieldScript) {
        List<Object> values = compositeFieldScript.getValues(this.fieldName);
        if (values == null) {
            return;
        }
        for (Object value : values) {
            this.emitFromObject(value);
        }
    }

    protected abstract void emitFromObject(Object var1);

    protected final void emitFromSource() {
        for (Object v : this.extractFromSource(this.fieldName)) {
            this.emitFromObject(v);
        }
    }

    protected final void checkMaxSize(int currentSize) {
        if (currentSize >= 100) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Runtime field [%s] is emitting [%s] values while the maximum number of values allowed is [%s]", this.fieldName, currentSize + 1, 100));
        }
    }

    public abstract void execute();
}

