/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class SeqNoFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_seq_no";
    public static final String CONTENT_TYPE = "_seq_no";
    public static final String PRIMARY_TERM_NAME = "_primary_term";
    public static final String TOMBSTONE_NAME = "_tombstone";
    public static final SeqNoFieldMapper INSTANCE = new SeqNoFieldMapper();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> INSTANCE);

    public SeqNoFieldMapper() {
        super(SeqNoFieldType.INSTANCE);
    }

    @Override
    public void preParse(DocumentParserContext context) {
        SequenceIDFields seqID = SequenceIDFields.emptySeqID();
        context.seqID(seqID);
        seqID.addFields(context.doc());
    }

    @Override
    public void postParse(DocumentParserContext context) throws IOException {
        SequenceIDFields seqID = context.seqID();
        assert (seqID != null);
        Version versionCreated = context.indexSettings().getIndexVersionCreated();
        boolean includePrimaryTerm = versionCreated.before(Version.V_6_1_0);
        for (LuceneDocument doc : context.nonRootDocuments()) {
            doc.add(seqID.seqNo);
            doc.add(seqID.seqNoDocValue);
            if (!includePrimaryTerm) continue;
            doc.add(seqID.primaryTerm);
        }
    }

    @Override
    protected String contentType() {
        return "_seq_no";
    }

    static final class SeqNoFieldType
    extends SimpleMappedFieldType {
        private static final SeqNoFieldType INSTANCE = new SeqNoFieldType();

        private SeqNoFieldType() {
            super("_seq_no", true, false, true, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_seq_no";
        }

        private long parse(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a long");
                }
                if (doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Long.parseLong(value.toString());
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query termQuery(Object value, @Nullable SearchExecutionContext context) {
            long v = this.parse(value);
            return LongPoint.newExactQuery(this.name(), v);
        }

        @Override
        public Query termsQuery(Collection<?> values, @Nullable SearchExecutionContext context) {
            long[] v = values.stream().mapToLong(this::parse).toArray();
            return LongPoint.newSetQuery(this.name(), v);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                l = this.parse(lowerTerm);
                if (!includeLower) {
                    if (l == Long.MAX_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    ++l;
                }
            }
            if (upperTerm != null) {
                u = this.parse(upperTerm);
                if (!includeUpper) {
                    if (u == Long.MIN_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    --u;
                }
            }
            return LongPoint.newRangeQuery(this.name(), l, u);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG);
        }
    }

    public static class SequenceIDFields {
        public final Field seqNo;
        public final Field seqNoDocValue;
        public final Field primaryTerm;
        public final Field tombstoneField;

        private SequenceIDFields(Field seqNo, Field seqNoDocValue, Field primaryTerm, Field tombstoneField) {
            Objects.requireNonNull(seqNo, "sequence number field cannot be null");
            Objects.requireNonNull(seqNoDocValue, "sequence number dv field cannot be null");
            Objects.requireNonNull(primaryTerm, "primary term field cannot be null");
            this.seqNo = seqNo;
            this.seqNoDocValue = seqNoDocValue;
            this.primaryTerm = primaryTerm;
            this.tombstoneField = tombstoneField;
        }

        public void addFields(LuceneDocument document) {
            document.add(this.seqNo);
            document.add(this.seqNoDocValue);
            document.add(this.primaryTerm);
            if (this.tombstoneField != null) {
                document.add(this.tombstoneField);
            }
        }

        public static SequenceIDFields emptySeqID() {
            return new SequenceIDFields(new LongPoint("_seq_no", -2L), new NumericDocValuesField("_seq_no", -2L), new NumericDocValuesField(SeqNoFieldMapper.PRIMARY_TERM_NAME, 0L), null);
        }

        public static SequenceIDFields tombstone() {
            return new SequenceIDFields(new LongPoint("_seq_no", -2L), new NumericDocValuesField("_seq_no", -2L), new NumericDocValuesField(SeqNoFieldMapper.PRIMARY_TERM_NAME, 0L), new NumericDocValuesField(SeqNoFieldMapper.TOMBSTONE_NAME, 1L));
        }
    }
}

