/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.http.HttpPipelinedRequest;
import org.elasticsearch.http.HttpPipelinedResponse;
import org.elasticsearch.http.HttpPipeliningAggregator;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.nio.NettyListener;

public class NioHttpPipeliningHandler
extends ChannelDuplexHandler {
    private final Logger logger;
    private final HttpPipeliningAggregator<NettyListener> aggregator;

    public NioHttpPipeliningHandler(Logger logger, int maxEventsHeld) {
        this.logger = logger;
        this.aggregator = new HttpPipeliningAggregator(maxEventsHeld);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        assert (msg instanceof HttpRequest) : "Invalid message type: " + msg.getClass();
        HttpPipelinedRequest pipelinedRequest = this.aggregator.read((HttpRequest)msg);
        ctx.fireChannelRead(pipelinedRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        assert (msg instanceof HttpPipelinedResponse) : "Invalid message type: " + msg.getClass();
        HttpPipelinedResponse response = (HttpPipelinedResponse)msg;
        boolean success = false;
        try {
            NettyListener listener = NettyListener.fromChannelPromise(promise);
            List<Tuple<HttpPipelinedResponse, NettyListener>> readyResponses = this.aggregator.write(response, listener);
            success = true;
            for (Tuple<HttpPipelinedResponse, NettyListener> responseToWrite : readyResponses) {
                ctx.write(responseToWrite.v1().getDelegateRequest(), responseToWrite.v2());
            }
        }
        catch (IllegalStateException e) {
            ctx.channel().close();
        }
        finally {
            if (!success) {
                promise.setFailure(new ClosedChannelException());
            }
        }
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        List<Tuple<HttpPipelinedResponse, NettyListener>> inflightResponses = this.aggregator.removeAllInflightResponses();
        if (!inflightResponses.isEmpty()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            for (Tuple<HttpPipelinedResponse, NettyListener> inflightResponse : inflightResponses) {
                try {
                    inflightResponse.v2().setFailure(closedChannelException);
                }
                catch (RuntimeException e) {
                    this.logger.error("unexpected error while releasing pipelined http responses", (Throwable)e);
                }
            }
        }
        ctx.close(promise);
    }
}

