/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpRequest
implements HttpRequest {
    private final FullHttpRequest request;
    private final BytesReference content;
    private final HttpHeadersMap headers;
    private final AtomicBoolean released;
    private final Exception inboundException;
    private final boolean pooled;

    Netty4HttpRequest(FullHttpRequest request) {
        this(request, new HttpHeadersMap(request.headers()), new AtomicBoolean(false), true, Netty4Utils.toBytesReference(request.content()));
    }

    Netty4HttpRequest(FullHttpRequest request, Exception inboundException) {
        this(request, new HttpHeadersMap(request.headers()), new AtomicBoolean(false), true, Netty4Utils.toBytesReference(request.content()), inboundException);
    }

    private Netty4HttpRequest(FullHttpRequest request, HttpHeadersMap headers, AtomicBoolean released, boolean pooled, BytesReference content) {
        this(request, headers, released, pooled, content, null);
    }

    private Netty4HttpRequest(FullHttpRequest request, HttpHeadersMap headers, AtomicBoolean released, boolean pooled, BytesReference content, Exception inboundException) {
        this.request = request;
        this.headers = headers;
        this.content = content;
        this.pooled = pooled;
        this.released = released;
        this.inboundException = inboundException;
    }

    @Override
    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.method();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        if (httpMethod == HttpMethod.PATCH) {
            return RestRequest.Method.PATCH;
        }
        if (httpMethod == HttpMethod.TRACE) {
            return RestRequest.Method.TRACE;
        }
        if (httpMethod == HttpMethod.CONNECT) {
            return RestRequest.Method.CONNECT;
        }
        throw new IllegalArgumentException("Unexpected http method: " + httpMethod);
    }

    @Override
    public String uri() {
        return this.request.uri();
    }

    @Override
    public BytesReference content() {
        assert (!this.released.get());
        return this.content;
    }

    @Override
    public void release() {
        if (this.pooled && this.released.compareAndSet(false, true)) {
            this.request.release();
        }
    }

    @Override
    public HttpRequest releaseAndCopy() {
        assert (!this.released.get());
        if (!this.pooled) {
            return this;
        }
        try {
            ByteBuf copiedContent = Unpooled.copiedBuffer(this.request.content());
            Netty4HttpRequest netty4HttpRequest = new Netty4HttpRequest(new DefaultFullHttpRequest(this.request.protocolVersion(), this.request.method(), this.request.uri(), copiedContent, this.request.headers(), this.request.trailingHeaders()), this.headers, new AtomicBoolean(false), false, Netty4Utils.toBytesReference(copiedContent));
            return netty4HttpRequest;
        }
        finally {
            this.release();
        }
    }

    @Override
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> strictCookies() {
        Set<Cookie> cookies;
        String cookieString = this.request.headers().get(HttpHeaderNames.COOKIE);
        if (cookieString != null && !(cookies = ServerCookieDecoder.STRICT.decode(cookieString)).isEmpty()) {
            return ServerCookieEncoder.STRICT.encode((Collection<? extends Cookie>)cookies);
        }
        return Collections.emptyList();
    }

    @Override
    public HttpRequest.HttpVersion protocolVersion() {
        if (this.request.protocolVersion().equals(HttpVersion.HTTP_1_0)) {
            return HttpRequest.HttpVersion.HTTP_1_0;
        }
        if (this.request.protocolVersion().equals(HttpVersion.HTTP_1_1)) {
            return HttpRequest.HttpVersion.HTTP_1_1;
        }
        throw new IllegalArgumentException("Unexpected http protocol version: " + this.request.protocolVersion());
    }

    @Override
    public HttpRequest removeHeader(String header) {
        DefaultHttpHeaders headersWithoutContentTypeHeader = new DefaultHttpHeaders();
        ((HttpHeaders)headersWithoutContentTypeHeader).add(this.request.headers());
        ((HttpHeaders)headersWithoutContentTypeHeader).remove(header);
        DefaultHttpHeaders trailingHeaders = new DefaultHttpHeaders();
        ((HttpHeaders)trailingHeaders).add(this.request.trailingHeaders());
        ((HttpHeaders)trailingHeaders).remove(header);
        DefaultFullHttpRequest requestWithoutHeader = new DefaultFullHttpRequest(this.request.protocolVersion(), this.request.method(), this.request.uri(), this.request.content(), headersWithoutContentTypeHeader, trailingHeaders);
        return new Netty4HttpRequest(requestWithoutHeader, new HttpHeadersMap(requestWithoutHeader.headers()), this.released, this.pooled, this.content);
    }

    @Override
    public Netty4HttpResponse createResponse(RestStatus status, BytesReference content) {
        return new Netty4HttpResponse(this.request.headers(), this.request.protocolVersion(), status, content);
    }

    @Override
    public Exception getInboundException() {
        return this.inboundException;
    }

    public FullHttpRequest nettyRequest() {
        return this.request;
    }

    private static class HttpHeadersMap
    implements Map<String, List<String>> {
        private final HttpHeaders httpHeaders;

        private HttpHeadersMap(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
        }

        @Override
        public int size() {
            return this.httpHeaders.size();
        }

        @Override
        public boolean isEmpty() {
            return this.httpHeaders.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof String && this.httpHeaders.contains((String)key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean containsValue(Object value) {
            if (!(value instanceof List)) return false;
            if (!this.httpHeaders.names().stream().map(this.httpHeaders::getAll).anyMatch(value::equals)) return false;
            return true;
        }

        @Override
        public List<String> get(Object key) {
            return key instanceof String ? this.httpHeaders.getAll((String)key) : null;
        }

        @Override
        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public List<String> remove(Object key) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void putAll(Map<? extends String, ? extends List<String>> m) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public Set<String> keySet() {
            return this.httpHeaders.names();
        }

        @Override
        public Collection<List<String>> values() {
            return this.httpHeaders.names().stream().map(k -> Collections.unmodifiableList(this.httpHeaders.getAll((String)k))).collect(Collectors.toList());
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return this.httpHeaders.names().stream().map(k -> new AbstractMap.SimpleImmutableEntry<String, List<String>>((String)k, this.httpHeaders.getAll((String)k))).collect(Collectors.toSet());
        }
    }
}

