/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.core.CheckedFunction;

public final class ObjectParserHelper<Value, Context> {
    public void declareRawObject(AbstractObjectParser<Value, Context> parser, BiConsumer<Value, BytesReference> consumer, ParseField field) {
        CheckedFunction<XContentParser, BytesReference, IOException> bytesParser = this.getBytesParser();
        parser.declareField(consumer, bytesParser, field, ObjectParser.ValueType.OBJECT);
    }

    public void declareRawObjectOrNull(AbstractObjectParser<Value, Context> parser, BiConsumer<Value, BytesReference> consumer, ParseField field) {
        CheckedFunction<XContentParser, BytesReference, IOException> bytesParser = this.getBytesParser();
        parser.declareField(consumer, bytesParser, field, ObjectParser.ValueType.OBJECT_OR_NULL);
    }

    private CheckedFunction<XContentParser, BytesReference, IOException> getBytesParser() {
        return p -> {
            try (XContentBuilder builder = JsonXContent.contentBuilder();){
                builder.copyCurrentStructure((XContentParser)p);
                BytesReference bytesReference = BytesReference.bytes(builder);
                return bytesReference;
            }
        };
    }
}

