/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.indices.InvalidAliasNameException;

public class AliasValidator {
    public void validateAlias(Alias alias, String index, Metadata metadata) {
        this.validateAlias(alias.name(), index, alias.indexRouting(), AliasValidator.lookup(metadata));
    }

    public void validateAliasMetadata(AliasMetadata aliasMetadata, String index, Metadata metadata) {
        this.validateAlias(aliasMetadata.alias(), index, aliasMetadata.indexRouting(), AliasValidator.lookup(metadata));
    }

    public void validateAliasStandalone(Alias alias) {
        this.validateAliasStandalone(alias.name(), alias.indexRouting());
        if (Strings.hasLength(alias.filter())) {
            try {
                XContentHelper.convertToMap(XContentFactory.xContent(alias.filter()), alias.filter(), false);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to parse filter for alias [" + alias.name() + "]", e);
            }
        }
    }

    public void validateAlias(String alias, String index, @Nullable String indexRouting, Function<String, String> lookup) {
        this.validateAliasStandalone(alias, indexRouting);
        if (!Strings.hasText(index)) {
            throw new IllegalArgumentException("index name is required");
        }
        String sameNameAsAlias = lookup.apply(alias);
        if (sameNameAsAlias != null) {
            throw new InvalidAliasNameException(alias, "an index or data stream exists with the same name as the alias");
        }
    }

    void validateAliasStandalone(String alias, String indexRouting) {
        if (!Strings.hasText(alias)) {
            throw new IllegalArgumentException("alias name is required");
        }
        MetadataCreateIndexService.validateIndexOrAliasName(alias, InvalidAliasNameException::new);
        if (indexRouting != null && indexRouting.indexOf(44) != -1) {
            throw new IllegalArgumentException("alias [" + alias + "] has several index routing values associated with it");
        }
    }

    public void validateAliasFilter(String alias, String filter, SearchExecutionContext searchExecutionContext, NamedXContentRegistry xContentRegistry) {
        assert (searchExecutionContext != null);
        try (XContentParser parser = XContentFactory.xContent(filter).createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter);){
            AliasValidator.validateAliasFilter(parser, searchExecutionContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    public void validateAliasFilter(String alias, BytesReference filter, SearchExecutionContext searchExecutionContext, NamedXContentRegistry xContentRegistry) {
        assert (searchExecutionContext != null);
        try (StreamInput inputStream = filter.streamInput();
             XContentParser parser = XContentFactory.xContentType(inputStream).xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter.streamInput());){
            AliasValidator.validateAliasFilter(parser, searchExecutionContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    private static void validateAliasFilter(XContentParser parser, SearchExecutionContext searchExecutionContext) throws IOException {
        QueryBuilder parseInnerQueryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
        QueryBuilder queryBuilder = Rewriteable.rewrite(parseInnerQueryBuilder, searchExecutionContext, true);
        queryBuilder.toQuery(searchExecutionContext);
    }

    private static Function<String, String> lookup(Metadata metadata) {
        return name -> Optional.ofNullable((IndexAbstraction)metadata.getIndicesLookup().get(name)).filter(indexAbstraction -> indexAbstraction.getType() != IndexAbstraction.Type.ALIAS).map(IndexAbstraction::getName).orElse(null);
    }
}

