/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.RestoreInfo;

public class RestoreSnapshotResponse
extends ActionResponse
implements ToXContentObject {
    @Nullable
    private final RestoreInfo restoreInfo;
    public static final ConstructingObjectParser<RestoreSnapshotResponse, Void> PARSER = new ConstructingObjectParser("restore_snapshot", true, v -> {
        RestoreInfo restoreInfo = (RestoreInfo)v[0];
        Boolean accepted = (Boolean)v[1];
        assert (accepted == null && restoreInfo != null || accepted != null && accepted.booleanValue() && restoreInfo == null) : "accepted: [" + accepted + "], restoreInfo: [" + restoreInfo + "]";
        return new RestoreSnapshotResponse(restoreInfo);
    });

    public RestoreSnapshotResponse(@Nullable RestoreInfo restoreInfo) {
        this.restoreInfo = restoreInfo;
    }

    public RestoreSnapshotResponse(StreamInput in) throws IOException {
        super(in);
        this.restoreInfo = RestoreInfo.readOptionalRestoreInfo(in);
    }

    public RestoreInfo getRestoreInfo() {
        return this.restoreInfo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.restoreInfo);
    }

    public RestStatus status() {
        if (this.restoreInfo == null) {
            return RestStatus.ACCEPTED;
        }
        return this.restoreInfo.status();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.restoreInfo != null) {
            builder.field("snapshot");
            this.restoreInfo.toXContent(builder, params);
        } else {
            builder.field("accepted", true);
        }
        builder.endObject();
        return builder;
    }

    public static RestoreSnapshotResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSnapshotResponse that = (RestoreSnapshotResponse)o;
        return Objects.equals(this.restoreInfo, that.restoreInfo);
    }

    public int hashCode() {
        return Objects.hash(this.restoreInfo);
    }

    public String toString() {
        return "RestoreSnapshotResponse{restoreInfo=" + this.restoreInfo + '}';
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> RestoreInfo.fromXContent(parser), new ParseField("snapshot", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("accepted", new String[0]));
    }
}

