/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.condition;

import java.io.IOException;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.xcontent.ObjectPath;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.support.Variables;

abstract class AbstractCompareCondition
implements ExecutableCondition {
    static final Pattern DATE_MATH_PATTERN = Pattern.compile("<\\{(.+)\\}>");
    static final Pattern PATH_PATTERN = Pattern.compile("\\{\\{(.+)\\}\\}");
    private final Clock clock;
    private final String type;

    protected AbstractCompareCondition(String type, Clock clock) {
        this.clock = clock;
        this.type = type;
    }

    public final Condition.Result execute(WatchExecutionContext ctx) {
        HashMap<String, Object> resolvedValues = new HashMap<String, Object>();
        Map<String, Object> model = Variables.createCtxParamsMap(ctx, ctx.payload());
        return this.doExecute(model, resolvedValues);
    }

    protected Object resolveConfiguredValue(Map<String, Object> resolvedValues, Map<String, Object> model, Object configuredValue) {
        if (configuredValue instanceof String) {
            Matcher matcher = DATE_MATH_PATTERN.matcher((String)configuredValue);
            if (matcher.matches()) {
                String dateMath = matcher.group(1);
                configuredValue = WatcherDateTimeUtils.parseDateMath((String)dateMath, (ZoneId)ZoneOffset.UTC, (Clock)this.clock);
                resolvedValues.put(dateMath, WatcherDateTimeUtils.formatDate((ZonedDateTime)((ZonedDateTime)configuredValue)));
            } else {
                matcher = PATH_PATTERN.matcher((String)configuredValue);
                if (matcher.matches()) {
                    String configuredPath = matcher.group(1);
                    configuredValue = ObjectPath.eval((String)configuredPath, model);
                    resolvedValues.put(configuredPath, configuredValue);
                }
            }
        }
        return configuredValue;
    }

    protected abstract Condition.Result doExecute(Map<String, Object> var1, Map<String, Object> var2);

    public String type() {
        return this.type;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().endObject();
    }
}

