/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.http;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.common.http.Scheme;

public class HttpProxy
implements ToXContentFragment {
    public static final HttpProxy NO_PROXY = new HttpProxy(null, null, null);
    private static final ParseField HOST = new ParseField("host", new String[0]);
    private static final ParseField PORT = new ParseField("port", new String[0]);
    private static final ParseField SCHEME = new ParseField("scheme", new String[0]);
    private String host;
    private Integer port;
    private Scheme scheme;

    public HttpProxy(String host, Integer port) {
        this.host = host;
        this.port = port;
    }

    public HttpProxy(String host, Integer port, Scheme scheme) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (Strings.hasText((String)this.host) && this.port != null) {
            builder.startObject("proxy").field("host", this.host).field("port", this.port);
            if (this.scheme != null) {
                builder.field("scheme", this.scheme.scheme());
            }
            builder.endObject();
        }
        return builder;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpProxy that = (HttpProxy)o;
        return Objects.equals(this.port, that.port) && Objects.equals(this.host, that.host) && Objects.equals((Object)this.scheme, (Object)that.scheme);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.scheme});
    }

    public static HttpProxy parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String host = null;
        Integer port = null;
        Scheme scheme = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (HOST.match(currentFieldName, parser.getDeprecationHandler())) {
                host = parser.text();
                continue;
            }
            if (SCHEME.match(currentFieldName, parser.getDeprecationHandler())) {
                scheme = Scheme.parse(parser.text());
                continue;
            }
            if (!PORT.match(currentFieldName, parser.getDeprecationHandler()) || (port = Integer.valueOf(parser.intValue())) > 0 && port < 65535) continue;
            throw new ElasticsearchParseException("Proxy port must be between 1 and 65534, but was " + port, new Object[0]);
        }
        if (port == null || host == null) {
            throw new ElasticsearchParseException("Proxy must contain 'port' and 'host' field", new Object[0]);
        }
        return new HttpProxy(host, port, scheme);
    }
}

