/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.search.sort.SortOrder;

final class PathArraySorter
extends IntroSorter {
    private final long[] points;
    private final double[] sortValues;
    private double sortValuePivot;
    private final SortOrder sortOrder;

    PathArraySorter(long[] points, double[] sortValues, SortOrder sortOrder) {
        assert (points.length == sortValues.length);
        this.points = points;
        this.sortValues = sortValues;
        this.sortValuePivot = 0.0;
        this.sortOrder = sortOrder;
    }

    public void sort() {
        this.sort(0, this.points.length);
    }

    protected void swap(int i, int j) {
        long tmpPoint = this.points[i];
        this.points[i] = this.points[j];
        this.points[j] = tmpPoint;
        double tmpSortValue = this.sortValues[i];
        this.sortValues[i] = this.sortValues[j];
        this.sortValues[j] = tmpSortValue;
    }

    protected void setPivot(int i) {
        this.sortValuePivot = this.sortValues[i];
    }

    protected int comparePivot(int j) {
        if (SortOrder.ASC.equals((Object)this.sortOrder)) {
            return Double.compare(this.sortValuePivot, this.sortValues[j]);
        }
        return Double.compare(this.sortValues[j], this.sortValuePivot);
    }
}

