/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.spatial.index.fielddata.Extent;

class TriangleTreeWriter {
    private TriangleTreeWriter() {
    }

    public static void writeTo(ByteBuffersDataOutput out, List<IndexableField> fields) throws IOException {
        Extent extent = new Extent();
        TriangleTreeNode node = TriangleTreeWriter.build(fields, extent);
        extent.writeCompressed(out);
        node.writeTo(out);
    }

    private static TriangleTreeNode build(List<IndexableField> fields, Extent extent) {
        byte[] scratch = new byte[28];
        if (fields.size() == 1) {
            TriangleTreeNode triangleTreeNode = new TriangleTreeNode(TriangleTreeWriter.toDecodedTriangle(fields.get(0), scratch));
            extent.addRectangle(triangleTreeNode.minX, triangleTreeNode.minY, triangleTreeNode.maxX, triangleTreeNode.maxY);
            return triangleTreeNode;
        }
        TriangleTreeNode[] nodes = new TriangleTreeNode[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            nodes[i] = new TriangleTreeNode(TriangleTreeWriter.toDecodedTriangle(fields.get(i), scratch));
            extent.addRectangle(nodes[i].minX, nodes[i].minY, nodes[i].maxX, nodes[i].maxY);
        }
        return TriangleTreeWriter.createTree(nodes, 0, fields.size() - 1, true);
    }

    private static ShapeField.DecodedTriangle toDecodedTriangle(IndexableField field, byte[] scratch) {
        BytesRef bytesRef = field.binaryValue();
        assert (bytesRef.length == 28);
        System.arraycopy(bytesRef.bytes, bytesRef.offset, scratch, 0, 28);
        ShapeField.DecodedTriangle decodedTriangle = new ShapeField.DecodedTriangle();
        ShapeField.decodeTriangle((byte[])scratch, (ShapeField.DecodedTriangle)decodedTriangle);
        return decodedTriangle;
    }

    private static TriangleTreeNode createTree(TriangleTreeNode[] components, int low, int high, boolean splitX) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        if (low < high) {
            Comparator<TriangleTreeNode> comparator = splitX ? Comparator.comparingInt(left -> ((TriangleTreeNode)left).minX).thenComparingInt(left -> ((TriangleTreeNode)left).maxX) : Comparator.comparingInt(left -> ((TriangleTreeNode)left).minY).thenComparingInt(left -> ((TriangleTreeNode)left).maxY);
            ArrayUtil.select((Object[])components, (int)low, (int)(high + 1), (int)mid, comparator);
        }
        TriangleTreeNode newNode = components[mid];
        newNode.left = TriangleTreeWriter.createTree(components, low, mid - 1, !splitX);
        newNode.right = TriangleTreeWriter.createTree(components, mid + 1, high, !splitX);
        if (newNode.left != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.left.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.left.maxY);
        }
        if (newNode.right != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.right.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.right.maxY);
        }
        return newNode;
    }

    private static class TriangleTreeNode {
        private int minY;
        private int maxY;
        private int minX;
        private int maxX;
        private TriangleTreeNode left;
        private TriangleTreeNode right;
        private final ShapeField.DecodedTriangle component;

        private TriangleTreeNode(ShapeField.DecodedTriangle component) {
            this.minY = Math.min(Math.min(component.aY, component.bY), component.cY);
            this.maxY = Math.max(Math.max(component.aY, component.bY), component.cY);
            this.minX = Math.min(Math.min(component.aX, component.bX), component.cX);
            this.maxX = Math.max(Math.max(component.aX, component.bX), component.cX);
            this.component = component;
        }

        private void writeTo(ByteBuffersDataOutput out) throws IOException {
            ByteBuffersDataOutput scratchBuffer = ByteBuffersDataOutput.newResettableInstance();
            this.writeMetadata(out);
            this.writeComponent(out);
            if (this.left != null) {
                this.left.writeNode(out, this.maxX, this.maxY, scratchBuffer);
            }
            if (this.right != null) {
                this.right.writeNode(out, this.maxX, this.maxY, scratchBuffer);
            }
        }

        private void writeNode(ByteBuffersDataOutput out, int parentMaxX, int parentMaxY, ByteBuffersDataOutput scratchBuffer) throws IOException {
            out.writeVLong((long)parentMaxX - (long)this.maxX);
            out.writeVLong((long)parentMaxY - (long)this.maxY);
            int size = this.nodeSize(false, parentMaxX, parentMaxY, scratchBuffer);
            out.writeVInt(size);
            this.writeMetadata(out);
            this.writeComponent(out);
            if (this.left != null) {
                this.left.writeNode(out, this.maxX, this.maxY, scratchBuffer);
            }
            if (this.right != null) {
                int rightSize = this.right.nodeSize(true, this.maxX, this.maxY, scratchBuffer);
                out.writeVInt(rightSize);
                this.right.writeNode(out, this.maxX, this.maxY, scratchBuffer);
            }
        }

        private void writeMetadata(ByteBuffersDataOutput out) {
            byte metadata = 0;
            metadata = (byte)(metadata | (this.left != null ? 1 : 0));
            metadata = (byte)(metadata | (this.right != null ? 2 : 0));
            if (this.component.type == ShapeField.DecodedTriangle.TYPE.POINT) {
                metadata = (byte)(metadata | 4);
            } else if (this.component.type == ShapeField.DecodedTriangle.TYPE.LINE) {
                metadata = (byte)(metadata | 8);
                metadata = (byte)(metadata | (this.component.ab ? 16 : 0));
            } else {
                metadata = (byte)(metadata | (this.component.ab ? 16 : 0));
                metadata = (byte)(metadata | (this.component.bc ? 32 : 0));
                metadata = (byte)(metadata | (this.component.ca ? 64 : 0));
            }
            out.writeByte(metadata);
        }

        private void writeComponent(ByteBuffersDataOutput out) throws IOException {
            out.writeVLong((long)this.maxX - (long)this.component.aX);
            out.writeVLong((long)this.maxY - (long)this.component.aY);
            if (this.component.type == ShapeField.DecodedTriangle.TYPE.POINT) {
                return;
            }
            out.writeVLong((long)this.maxX - (long)this.component.bX);
            out.writeVLong((long)this.maxY - (long)this.component.bY);
            if (this.component.type == ShapeField.DecodedTriangle.TYPE.LINE) {
                return;
            }
            out.writeVLong((long)this.maxX - (long)this.component.cX);
            out.writeVLong((long)this.maxY - (long)this.component.cY);
        }

        private int nodeSize(boolean includeBox, int parentMaxX, int parentMaxY, ByteBuffersDataOutput scratchBuffer) throws IOException {
            int size = 0;
            ++size;
            size += this.componentSize(scratchBuffer);
            if (this.left != null) {
                size += this.left.nodeSize(true, this.maxX, this.maxY, scratchBuffer);
            }
            if (this.right != null) {
                int rightSize = this.right.nodeSize(true, this.maxX, this.maxY, scratchBuffer);
                scratchBuffer.reset();
                scratchBuffer.writeVLong((long)rightSize);
                size = (int)((long)size + scratchBuffer.size());
                size += rightSize;
            }
            if (includeBox) {
                int jumpSize = size;
                scratchBuffer.reset();
                scratchBuffer.writeVLong((long)parentMaxX - (long)this.maxX);
                scratchBuffer.writeVLong((long)parentMaxY - (long)this.maxY);
                scratchBuffer.writeVLong((long)jumpSize);
                size = (int)((long)size + scratchBuffer.size());
            }
            return size;
        }

        private int componentSize(ByteBuffersDataOutput scratchBuffer) throws IOException {
            scratchBuffer.reset();
            if (this.component.type == ShapeField.DecodedTriangle.TYPE.POINT) {
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.aX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.aY);
            } else if (this.component.type == ShapeField.DecodedTriangle.TYPE.LINE) {
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.aX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.aY);
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.bX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.bY);
            } else {
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.aX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.aY);
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.bX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.bY);
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.cX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.cY);
            }
            return Math.toIntExact(scratchBuffer.size());
        }
    }
}

