/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.rule;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutionException;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeUtils;

public abstract class RuleExecutor<TreeType extends Node<TreeType>> {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Iterable<Batch> batches = this.batches();

    protected abstract Iterable<Batch> batches();

    protected TreeType execute(TreeType plan) {
        return (TreeType)this.executeWithInfo(plan).after;
    }

    protected ExecutionInfo executeWithInfo(TreeType plan) {
        Object currentPlan = plan;
        long totalDuration = 0L;
        LinkedHashMap transformations = new LinkedHashMap();
        for (Batch batch : this.batches) {
            int batchRuns = 0;
            ArrayList<Transformation> tfs = new ArrayList<Transformation>();
            transformations.put(batch, tfs);
            boolean hasChanged = false;
            long batchStart = System.currentTimeMillis();
            long batchDuration = 0L;
            do {
                hasChanged = false;
                ++batchRuns;
                for (Rule rule : batch.rules) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("About to apply rule {}", (Object)rule);
                    }
                    Transformation tf = new Transformation(this, currentPlan, rule);
                    tfs.add(tf);
                    currentPlan = tf.after;
                    if (tf.hasChanged()) {
                        hasChanged = true;
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace("Rule {} applied\n{}", (Object)rule, (Object)NodeUtils.diffString(tf.before, tf.after));
                        continue;
                    }
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("Rule {} applied w/o changes", (Object)rule);
                }
                batchDuration = System.currentTimeMillis() - batchStart;
            } while (hasChanged && !batch.limit.reached(batchRuns));
            totalDuration += batchDuration;
            if (!this.log.isTraceEnabled()) continue;
            Object before = plan;
            Object after = plan;
            if (!tfs.isEmpty()) {
                before = ((Transformation)tfs.get(0)).before;
                after = ((Transformation)tfs.get(tfs.size() - 1)).after;
            }
            this.log.trace("Batch {} applied took {}\n{}", (Object)batch.name, (Object)TimeValue.timeValueMillis((long)batchDuration), (Object)NodeUtils.diffString(before, after));
        }
        if (!((Node)currentPlan).equals(plan) && this.log.isDebugEnabled()) {
            this.log.debug("Tree transformation took {}\n{}", (Object)TimeValue.timeValueMillis((long)totalDuration), (Object)NodeUtils.diffString(plan, currentPlan));
        }
        return new ExecutionInfo(this, plan, currentPlan, transformations);
    }

    public static class ExecutionInfo {
        private final TreeType before;
        private final TreeType after;
        private final Map<Batch, List<Transformation>> transformations;
        final /* synthetic */ RuleExecutor this$0;

        ExecutionInfo(TreeType before, TreeType after, Map<Batch, List<Transformation>> transformations) {
            this.this$0 = this$0;
            this.before = before;
            this.after = after;
            this.transformations = transformations;
        }

        public TreeType before() {
            return this.before;
        }

        public TreeType after() {
            return this.after;
        }

        public Map<Batch, List<Transformation>> transformations() {
            return this.transformations;
        }
    }

    public class Batch {
        private final String name;
        private final Rule<?, TreeType>[] rules;
        private final Limiter limit;

        @SafeVarargs
        public Batch(String name, Limiter limit, Rule<?, TreeType> ... rules) {
            this.name = name;
            this.limit = limit;
            this.rules = rules;
        }

        @SafeVarargs
        public Batch(String name, Rule<?, TreeType> ... rules) {
            this(name, Limiter.DEFAULT, rules);
        }

        public String name() {
            return this.name;
        }
    }

    public static class Transformation {
        private final TreeType before;
        private final TreeType after;
        private final Rule<?, TreeType> rule;
        private Boolean lazyHasChanged;
        final /* synthetic */ RuleExecutor this$0;

        Transformation(TreeType plan, Rule<?, TreeType> rule) {
            this.this$0 = this$0;
            this.rule = rule;
            this.before = plan;
            this.after = (Node)rule.apply(this.before);
        }

        public boolean hasChanged() {
            if (this.lazyHasChanged == null) {
                this.lazyHasChanged = !((Node)this.before).equals(this.after);
            }
            return this.lazyHasChanged;
        }

        public String ruleName() {
            return this.rule.name();
        }

        public TreeType before() {
            return this.before;
        }

        public TreeType after() {
            return this.after;
        }
    }

    public static class Limiter {
        public static final Limiter DEFAULT = new Limiter(100);
        public static final Limiter ONCE = new Limiter(1){

            @Override
            boolean reached(int runs) {
                return runs >= 1;
            }
        };
        private final int runs;

        public Limiter(int maximumRuns) {
            this.runs = maximumRuns;
        }

        boolean reached(int runs) {
            if (runs >= this.runs) {
                throw new RuleExecutionException("Rule execution limit [{}] reached", runs);
            }
            return false;
        }
    }
}

