/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.plugin;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncResultsService;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.GetAsyncResultRequest;
import org.elasticsearch.xpack.core.async.StoredAsyncResponse;
import org.elasticsearch.xpack.core.async.StoredAsyncTask;
import org.elasticsearch.xpack.ql.async.AsyncTaskManagementService;

public abstract class AbstractTransportQlAsyncGetResultsAction<Response extends ActionResponse, AsyncTask extends StoredAsyncTask<Response>>
extends HandledTransportAction<GetAsyncResultRequest, Response> {
    private final String actionName;
    private final AsyncResultsService<AsyncTask, StoredAsyncResponse<Response>> resultsService;
    private final TransportService transportService;

    public AbstractTransportQlAsyncGetResultsAction(String actionName, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool, BigArrays bigArrays, Class<? extends AsyncTask> asynkTaskClass) {
        super(actionName, transportService, actionFilters, GetAsyncResultRequest::new);
        this.actionName = actionName;
        this.transportService = transportService;
        this.resultsService = this.createResultsService(transportService, clusterService, registry, client, threadPool, bigArrays, asynkTaskClass);
    }

    AsyncResultsService<AsyncTask, StoredAsyncResponse<Response>> createResultsService(TransportService transportService, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool, BigArrays bigArrays, Class<? extends AsyncTask> asyncTaskClass) {
        Writeable.Reader reader = in -> new StoredAsyncResponse(this.responseReader(), in);
        AsyncTaskIndexService store = new AsyncTaskIndexService(".async-search", clusterService, threadPool.getThreadContext(), client, "async_search", reader, registry, bigArrays);
        return new AsyncResultsService(store, false, asyncTaskClass, (task, listener, timeout) -> AsyncTaskManagementService.addCompletionListener(threadPool, task, listener, timeout), transportService.getTaskManager(), clusterService);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doExecute(Task task, GetAsyncResultRequest request, ActionListener<Response> listener) {
        DiscoveryNode node = this.resultsService.getNode(request.getId());
        if (node != null && !this.resultsService.isLocalNode(node)) {
            this.transportService.sendRequest(node, this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, this.responseReader(), "same"));
            return;
        }
        this.resultsService.retrieveResult(request, ActionListener.wrap(r -> {
            if (r.getException() != null) {
                listener.onFailure(r.getException());
            } else {
                listener.onResponse((Object)((ActionResponse)r.getResponse()));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public abstract Writeable.Reader<Response> responseReader();
}

