/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.index;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeRegistry;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.DateEsField;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.InvalidMappedField;
import org.elasticsearch.xpack.ql.type.KeywordEsField;
import org.elasticsearch.xpack.ql.type.TextEsField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;

public class IndexResolver {
    public static final String SQL_TABLE = "TABLE";
    public static final String SQL_VIEW = "VIEW";
    private static final IndicesOptions INDICES_ONLY_OPTIONS = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_ALIASES, IndicesOptions.Option.IGNORE_THROTTLED), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    private static final IndicesOptions FROZEN_INDICES_OPTIONS = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_ALIASES), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    public static final IndicesOptions FIELD_CAPS_INDICES_OPTIONS = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_THROTTLED), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    public static final IndicesOptions FIELD_CAPS_FROZEN_INDICES_OPTIONS = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    private static final String UNMAPPED = "unmapped";
    private final Client client;
    private final String clusterName;
    private final DataTypeRegistry typeRegistry;

    public IndexResolver(Client client, String clusterName, DataTypeRegistry typeRegistry) {
        this.client = client;
        this.clusterName = clusterName;
        this.typeRegistry = typeRegistry;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public void resolveNames(String indexWildcard, String javaRegex, EnumSet<IndexType> types, ActionListener<Set<IndexInfo>> listener) {
        boolean retrieveAliases = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.ALIAS);
        boolean retrieveIndices = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.STANDARD_INDEX);
        boolean retrieveFrozenIndices = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.FROZEN_INDEX);
        String[] indices = Strings.commaDelimitedListToStringArray((String)indexWildcard);
        if (retrieveAliases) {
            GetAliasesRequest aliasRequest = ((GetAliasesRequest)new GetAliasesRequest().local(true)).aliases(indices).indicesOptions(IndicesOptions.lenientExpandOpen());
            this.client.admin().indices().getAliases(aliasRequest, ActionListener.wrap(aliases -> this.resolveIndices(indices, javaRegex, (GetAliasesResponse)aliases, retrieveIndices, retrieveFrozenIndices, listener), ex -> {
                if (ex instanceof IndexNotFoundException || ex instanceof ElasticsearchSecurityException) {
                    this.resolveIndices(indices, javaRegex, null, retrieveIndices, retrieveFrozenIndices, listener);
                } else {
                    listener.onFailure(ex);
                }
            }));
        } else {
            this.resolveIndices(indices, javaRegex, null, retrieveIndices, retrieveFrozenIndices, listener);
        }
    }

    private void resolveIndices(String[] indices, String javaRegex, GetAliasesResponse aliases, boolean retrieveIndices, boolean retrieveFrozenIndices, ActionListener<Set<IndexInfo>> listener) {
        if (retrieveIndices || retrieveFrozenIndices) {
            GetIndexRequest indexRequest = (GetIndexRequest)((GetIndexRequest)((GetIndexRequest)new GetIndexRequest().local(true)).indices(indices)).features(new GetIndexRequest.Feature[]{GetIndexRequest.Feature.SETTINGS}).includeDefaults(false).indicesOptions(INDICES_ONLY_OPTIONS);
            if (retrieveFrozenIndices) {
                indexRequest.indicesOptions(FROZEN_INDICES_OPTIONS);
            }
            this.client.admin().indices().getIndex(indexRequest, ActionListener.wrap(response -> this.filterResults(javaRegex, aliases, (GetIndexResponse)response, retrieveIndices, retrieveFrozenIndices, listener), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.filterResults(javaRegex, aliases, null, false, false, listener);
        }
    }

    private void filterResults(String javaRegex, GetAliasesResponse aliases, GetIndexResponse indices, boolean retrieveIndices, boolean retrieveFrozenIndices, ActionListener<Set<IndexInfo>> listener) {
        String[] indicesNames;
        Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
        TreeSet<IndexInfo> result = new TreeSet<IndexInfo>(Comparator.comparing(IndexInfo::name));
        if (aliases != null) {
            for (ObjectCursor cursor : aliases.getAliases().values()) {
                for (AliasMetadata amd : (List)cursor.value) {
                    String alias = amd.alias();
                    if (alias == null || pattern != null && !pattern.matcher(alias).matches()) continue;
                    result.add(new IndexInfo(alias, IndexType.ALIAS));
                }
            }
        }
        String[] stringArray = indicesNames = indices != null ? indices.indices() : null;
        if (indicesNames != null) {
            for (String indexName : indicesNames) {
                boolean isFrozen;
                boolean bl = isFrozen = retrieveFrozenIndices && ((Settings)indices.getSettings().get((Object)indexName)).getAsBoolean("index.frozen", Boolean.valueOf(false)) != false;
                if (pattern != null && !pattern.matcher(indexName).matches()) continue;
                result.add(new IndexInfo(indexName, isFrozen ? IndexType.FROZEN_INDEX : IndexType.STANDARD_INDEX));
            }
        }
        listener.onResponse(result);
    }

    public void resolveAsMergedMapping(String indexWildcard, String javaRegex, IndicesOptions indicesOptions, Map<String, Object> runtimeMappings, ActionListener<IndexResolution> listener) {
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard, indicesOptions, runtimeMappings);
        this.client.fieldCaps(fieldRequest, ActionListener.wrap(response -> listener.onResponse((Object)IndexResolver.mergedMappings(this.typeRegistry, indexWildcard, response)), arg_0 -> listener.onFailure(arg_0)));
    }

    public void resolveAsMergedMapping(String indexWildcard, String javaRegex, boolean includeFrozen, Map<String, Object> runtimeMappings, ActionListener<IndexResolution> listener) {
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard, includeFrozen, runtimeMappings);
        this.client.fieldCaps(fieldRequest, ActionListener.wrap(response -> listener.onResponse((Object)IndexResolver.mergedMappings(this.typeRegistry, indexWildcard, response)), arg_0 -> listener.onFailure(arg_0)));
    }

    public static IndexResolution mergedMappings(DataTypeRegistry typeRegistry, String indexPattern, FieldCapabilitiesResponse fieldCapsResponse) {
        if (fieldCapsResponse.getIndices().length == 0) {
            return IndexResolution.notFound(indexPattern);
        }
        List<EsIndex> indices = IndexResolver.buildIndices(typeRegistry, null, fieldCapsResponse, null, i -> indexPattern, (n, types) -> {
            StringBuilder errorMessage = new StringBuilder();
            boolean hasUnmapped = types.containsKey(UNMAPPED);
            if (types.size() > (hasUnmapped ? 2 : 1)) {
                for (Map.Entry type : types.entrySet()) {
                    if (UNMAPPED.equals(type.getKey())) continue;
                    if (errorMessage.length() > 0) {
                        errorMessage.append(", ");
                    }
                    errorMessage.append("[");
                    errorMessage.append((String)type.getKey());
                    errorMessage.append("] in ");
                    errorMessage.append(Arrays.toString(((FieldCapabilities)type.getValue()).indices()));
                }
                errorMessage.insert(0, "mapped as [" + (types.size() - (hasUnmapped ? 1 : 0)) + "] incompatible types: ");
                return new InvalidMappedField((String)n, errorMessage.toString());
            }
            FieldCapabilities fieldCap = (FieldCapabilities)types.values().iterator().next();
            if (fieldCap.isAggregatable() && fieldCap.nonAggregatableIndices() != null) {
                errorMessage.append("mapped as aggregatable except in ");
                errorMessage.append(Arrays.toString(fieldCap.nonAggregatableIndices()));
            }
            if (fieldCap.isSearchable() && fieldCap.nonSearchableIndices() != null) {
                if (errorMessage.length() > 0) {
                    errorMessage.append(",");
                }
                errorMessage.append("mapped as searchable except in ");
                errorMessage.append(Arrays.toString(fieldCap.nonSearchableIndices()));
            }
            if (errorMessage.length() > 0) {
                return new InvalidMappedField((String)n, errorMessage.toString());
            }
            return null;
        });
        if (indices.size() > 1) {
            throw new QlIllegalArgumentException("Incorrect merging of mappings (likely due to a bug) - expect at most one but found [{}]", indices.size());
        }
        String indexName = fieldCapsResponse.getIndices()[0];
        return IndexResolution.valid(indices.isEmpty() ? new EsIndex(indexName, Collections.emptyMap()) : indices.get(0));
    }

    private static EsField createField(DataTypeRegistry typeRegistry, String fieldName, Map<String, Map<String, FieldCapabilities>> globalCaps, Map<String, EsField> hierarchicalMapping, Map<String, EsField> flattedMapping, Function<String, EsField> field) {
        Map<String, EsField> parentProps = hierarchicalMapping;
        int dot = fieldName.lastIndexOf(46);
        String fullFieldName = fieldName;
        EsField parent = null;
        if (dot >= 0) {
            String parentName = fieldName.substring(0, dot);
            fieldName = fieldName.substring(dot + 1);
            parent = flattedMapping.get(parentName);
            if (parent == null) {
                Function<String, EsField> fieldFunction;
                Map<String, FieldCapabilities> map = globalCaps.get(parentName);
                if (map == null) {
                    fieldFunction = s -> IndexResolver.createField(typeRegistry, s, DataTypes.OBJECT.esType(), new TreeMap<String, EsField>(), false, true);
                } else {
                    Iterator<FieldCapabilities> iterator = map.values().iterator();
                    FieldCapabilities parentCap = iterator.next();
                    if (iterator.hasNext() && UNMAPPED.equals(parentCap.getType())) {
                        parentCap = iterator.next();
                    }
                    FieldCapabilities parentC = parentCap;
                    fieldFunction = s -> IndexResolver.createField(typeRegistry, s, parentC.getType(), new TreeMap<String, EsField>(), parentC.isAggregatable(), false);
                }
                parent = IndexResolver.createField(typeRegistry, parentName, globalCaps, hierarchicalMapping, flattedMapping, fieldFunction);
            }
            parentProps = parent.getProperties();
        }
        EsField esField = field.apply(fieldName);
        if (parent != null && parent instanceof UnsupportedEsField) {
            UnsupportedEsField unsupportedParent = (UnsupportedEsField)parent;
            String inherited = unsupportedParent.getInherited();
            String type = unsupportedParent.getOriginalType();
            esField = inherited == null ? new UnsupportedEsField(esField.getName(), type, unsupportedParent.getName(), esField.getProperties()) : new UnsupportedEsField(esField.getName(), type, inherited, esField.getProperties());
        }
        parentProps.put(fieldName, esField);
        flattedMapping.put(fullFieldName, esField);
        return esField;
    }

    private static EsField createField(DataTypeRegistry typeRegistry, String fieldName, String typeName, Map<String, EsField> props, boolean isAggregateable, boolean isAlias) {
        DataType esType = typeRegistry.fromEs(typeName);
        if (esType == DataTypes.TEXT) {
            return new TextEsField(fieldName, props, false, isAlias);
        }
        if (esType == DataTypes.KEYWORD) {
            int length = Short.MAX_VALUE;
            boolean normalized = false;
            return new KeywordEsField(fieldName, props, isAggregateable, length, normalized, isAlias);
        }
        if (esType == DataTypes.DATETIME) {
            return DateEsField.dateEsField(fieldName, props, isAggregateable);
        }
        if (esType == DataTypes.UNSUPPORTED) {
            return new UnsupportedEsField(fieldName, typeName, null, props);
        }
        return new EsField(fieldName, esType, props, isAggregateable, isAlias);
    }

    private static FieldCapabilitiesRequest createFieldCapsRequest(String index, IndicesOptions indicesOptions, Map<String, Object> runtimeMappings) {
        return new FieldCapabilitiesRequest().indices(Strings.commaDelimitedListToStringArray((String)index)).fields(new String[]{"*"}).includeUnmapped(true).runtimeFields(runtimeMappings).indicesOptions(indicesOptions);
    }

    private static FieldCapabilitiesRequest createFieldCapsRequest(String index, boolean includeFrozen, Map<String, Object> runtimeMappings) {
        IndicesOptions indicesOptions = includeFrozen ? FIELD_CAPS_FROZEN_INDICES_OPTIONS : FIELD_CAPS_INDICES_OPTIONS;
        return IndexResolver.createFieldCapsRequest(index, indicesOptions, runtimeMappings);
    }

    public void resolveAsSeparateMappings(String indexWildcard, String javaRegex, boolean includeFrozen, Map<String, Object> runtimeMappings, ActionListener<List<EsIndex>> listener) {
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard, includeFrozen, runtimeMappings);
        this.client.fieldCaps(fieldRequest, ActionListener.wrap(response -> this.client.admin().indices().getAliases(this.createGetAliasesRequest((FieldCapabilitiesResponse)response, includeFrozen), ActionListener.wrap(aliases -> listener.onResponse(IndexResolver.separateMappings(this.typeRegistry, javaRegex, response, (ImmutableOpenMap<String, List<AliasMetadata>>)aliases.getAliases())), ex -> {
            if (ex instanceof IndexNotFoundException || ex instanceof ElasticsearchSecurityException) {
                listener.onResponse(IndexResolver.separateMappings(this.typeRegistry, javaRegex, response, null));
            } else {
                listener.onFailure(ex);
            }
        })), arg_0 -> listener.onFailure(arg_0)));
    }

    private GetAliasesRequest createGetAliasesRequest(FieldCapabilitiesResponse response, boolean includeFrozen) {
        return ((GetAliasesRequest)new GetAliasesRequest().local(true)).aliases(new String[]{"*"}).indices(response.getIndices()).indicesOptions(includeFrozen ? FIELD_CAPS_FROZEN_INDICES_OPTIONS : FIELD_CAPS_INDICES_OPTIONS);
    }

    public static List<EsIndex> separateMappings(DataTypeRegistry typeRegistry, String javaRegex, FieldCapabilitiesResponse fieldCaps, ImmutableOpenMap<String, List<AliasMetadata>> aliases) {
        return IndexResolver.buildIndices(typeRegistry, javaRegex, fieldCaps, aliases, Function.identity(), (s, cap) -> null);
    }

    private static List<EsIndex> buildIndices(DataTypeRegistry typeRegistry, String javaRegex, FieldCapabilitiesResponse fieldCapsResponse, ImmutableOpenMap<String, List<AliasMetadata>> aliases, Function<String, String> indexNameProcessor, BiFunction<String, Map<String, FieldCapabilities>, InvalidMappedField> validityVerifier) {
        if (!(fieldCapsResponse.getIndices() != null && fieldCapsResponse.getIndices().length != 0 || aliases != null && !aliases.isEmpty())) {
            return Collections.emptyList();
        }
        HashSet<String> resolvedAliases = new HashSet<String>();
        if (aliases != null) {
            Iterator iterator = aliases.iterator();
            while (iterator.hasNext()) {
                for (AliasMetadata alias : (List)((ObjectObjectCursor)iterator.next()).value) {
                    resolvedAliases.add(alias.getAlias());
                }
            }
        }
        ArrayList<String> resolvedIndices = new ArrayList<String>(Arrays.asList(fieldCapsResponse.getIndices()));
        int mapSize = CollectionUtils.mapSize(resolvedIndices.size() + resolvedAliases.size());
        LinkedHashMap<String, Fields> indices = new LinkedHashMap<String, Fields>(mapSize);
        Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
        TreeSet<Map.Entry> sortedFields = new TreeSet<Map.Entry>(Collections.reverseOrder(Comparator.comparing(Map.Entry::getKey)));
        Map fieldCaps = fieldCapsResponse.get();
        sortedFields.addAll(fieldCaps.entrySet());
        for (Map.Entry entry : sortedFields) {
            String fieldName = (String)entry.getKey();
            if (fieldCapsResponse.isMetadataField(fieldName)) continue;
            LinkedHashMap<String, FieldCapabilities> types = new LinkedHashMap<String, FieldCapabilities>((Map)entry.getValue());
            InvalidMappedField invalidField = validityVerifier.apply(fieldName, types);
            Map<String, InvalidMappedField> invalidFieldsForAliases = IndexResolver.getInvalidFieldsForAliases(fieldName, types, aliases);
            FieldCapabilities unmapped = (FieldCapabilities)types.get(UNMAPPED);
            HashSet<String> unmappedIndices = unmapped != null ? new HashSet<String>(Arrays.asList(unmapped.indices())) : Collections.emptySet();
            for (Map.Entry typeEntry : types.entrySet()) {
                FieldCapabilities typeCap = (FieldCapabilities)typeEntry.getValue();
                String[] capIndices = typeCap.indices();
                ArrayList<String> concreteIndices = null;
                if (capIndices != null) {
                    if (unmappedIndices.isEmpty()) {
                        concreteIndices = new ArrayList<String>(Arrays.asList(capIndices));
                    } else {
                        concreteIndices = new ArrayList(capIndices.length);
                        for (String capIndex : capIndices) {
                            if (unmappedIndices.contains(capIndex)) continue;
                            concreteIndices.add(capIndex);
                        }
                    }
                } else {
                    concreteIndices = resolvedIndices;
                }
                LinkedHashSet uniqueAliases = new LinkedHashSet();
                if (aliases != null) {
                    for (String concreteIndex : concreteIndices) {
                        if (!aliases.containsKey((Object)concreteIndex)) continue;
                        List concreteIndexAliases = (List)aliases.get((Object)concreteIndex);
                        concreteIndexAliases.stream().forEach(e -> uniqueAliases.add(e.alias()));
                    }
                    concreteIndices.addAll(uniqueAliases);
                }
                for (String index : concreteIndices) {
                    String parentName;
                    boolean isIndexAlias = uniqueAliases.contains(index);
                    if (pattern != null && !pattern.matcher(index).matches() && !isIndexAlias) continue;
                    String indexName = isIndexAlias ? index : indexNameProcessor.apply(index);
                    Fields indexFields = (Fields)indices.get(indexName);
                    if (indexFields == null) {
                        indexFields = new Fields();
                        indices.put(indexName, indexFields);
                    }
                    EsField field = indexFields.flattedMapping.get(fieldName);
                    boolean createField = false;
                    if (!isIndexAlias) {
                        if (field == null || invalidField != null && !(field instanceof InvalidMappedField)) {
                            createField = true;
                        }
                    } else if (field == null && invalidFieldsForAliases.get(index) == null) {
                        createField = true;
                    }
                    if (!createField) continue;
                    int dot = fieldName.lastIndexOf(46);
                    Holder<Boolean> isAliasFieldType = new Holder<Boolean>(false);
                    if (dot >= 0 && indexFields.flattedMapping.get(parentName = fieldName.substring(0, dot)) == null && fieldCaps.get(parentName) == null) {
                        isAliasFieldType.set(true);
                    }
                    IndexResolver.createField(typeRegistry, fieldName, fieldCaps, indexFields.hierarchicalMapping, indexFields.flattedMapping, s -> invalidField != null ? invalidField : IndexResolver.createField(typeRegistry, s, typeCap.getType(), Collections.emptyMap(), typeCap.isAggregatable(), (Boolean)isAliasFieldType.get()));
                }
            }
        }
        ArrayList<EsIndex> foundIndices = new ArrayList<EsIndex>(indices.size());
        for (Map.Entry entry : indices.entrySet()) {
            foundIndices.add(new EsIndex((String)entry.getKey(), ((Fields)entry.getValue()).hierarchicalMapping));
        }
        foundIndices.sort(Comparator.comparing(EsIndex::name));
        return foundIndices;
    }

    private static Map<String, InvalidMappedField> getInvalidFieldsForAliases(String fieldName, Map<String, FieldCapabilities> types, ImmutableOpenMap<String, List<AliasMetadata>> aliases) {
        if (aliases == null || aliases.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, InvalidMappedField> invalidFields = new HashMap<String, InvalidMappedField>();
        HashMap typesErrors = new HashMap();
        HashMap aliasToIndices = new HashMap();
        for (ObjectObjectCursor index : aliases) {
            for (AliasMetadata aliasMetadata : (List)index.value) {
                String aliasName = aliasMetadata.alias();
                aliasToIndices.putIfAbsent(aliasName, new HashSet());
                ((Set)aliasToIndices.get(aliasName)).add((String)index.key);
            }
        }
        for (Map.Entry<String, FieldCapabilities> type : types.entrySet()) {
            String[] indices;
            String esFieldType = type.getKey();
            if (esFieldType == UNMAPPED || (indices = type.getValue().indices()) == null) continue;
            for (String index : indices) {
                List indexAliases = (List)aliases.get((Object)index);
                if (indexAliases == null) continue;
                for (AliasMetadata aliasMetadata : indexAliases) {
                    String aliasName = aliasMetadata.alias();
                    if (typesErrors.containsKey(aliasName)) {
                        ((Set)typesErrors.get(aliasName)).add(esFieldType);
                        continue;
                    }
                    HashSet<String> fieldTypes = new HashSet<String>();
                    fieldTypes.add(esFieldType);
                    typesErrors.put(aliasName, fieldTypes);
                }
            }
        }
        block5: for (String aliasName : aliasToIndices.keySet()) {
            Set esFieldTypes = (Set)typesErrors.get(aliasName);
            if (esFieldTypes != null && esFieldTypes.size() > 1) {
                invalidFields.put(aliasName, new InvalidMappedField(fieldName));
                continue;
            }
            for (Map.Entry<String, FieldCapabilities> type : types.entrySet()) {
                Set aliasIndices;
                if (type.getKey() == UNMAPPED) continue;
                FieldCapabilities f = type.getValue();
                if (f.nonAggregatableIndices() != null) {
                    aliasIndices = (Set)aliasToIndices.get(aliasName);
                    int nonAggregatableCount = 0;
                    for (String nonAggIndex : f.nonAggregatableIndices()) {
                        if (!aliasIndices.contains(nonAggIndex)) continue;
                        ++nonAggregatableCount;
                    }
                    if (nonAggregatableCount > 0 && nonAggregatableCount != aliasIndices.size()) {
                        invalidFields.put(aliasName, new InvalidMappedField(fieldName));
                        continue block5;
                    }
                }
                if (f.nonSearchableIndices() == null) continue;
                aliasIndices = (Set)aliasToIndices.get(aliasName);
                int nonSearchableCount = 0;
                for (String nonSearchIndex : f.nonSearchableIndices()) {
                    if (!aliasIndices.contains(nonSearchIndex)) continue;
                    ++nonSearchableCount;
                }
                if (nonSearchableCount <= 0 || nonSearchableCount == aliasIndices.size()) continue;
                invalidFields.put(aliasName, new InvalidMappedField(fieldName));
                continue block5;
            }
        }
        if (invalidFields.size() > 0) {
            return invalidFields;
        }
        return Collections.emptyMap();
    }

    public static enum IndexType {
        STANDARD_INDEX("TABLE", "INDEX"),
        ALIAS("VIEW", "ALIAS"),
        FROZEN_INDEX("TABLE", "FROZEN INDEX"),
        UNKNOWN("UNKNOWN", "UNKNOWN");

        public static final EnumSet<IndexType> VALID_INCLUDE_FROZEN;
        public static final EnumSet<IndexType> VALID_REGULAR;
        private final String toSql;
        private final String toNative;

        private IndexType(String sql, String toNative) {
            this.toSql = sql;
            this.toNative = toNative;
        }

        public String toSql() {
            return this.toSql;
        }

        public String toNative() {
            return this.toNative;
        }

        static {
            VALID_INCLUDE_FROZEN = EnumSet.of(STANDARD_INDEX, ALIAS, FROZEN_INDEX);
            VALID_REGULAR = EnumSet.of(STANDARD_INDEX, ALIAS);
        }
    }

    public static class IndexInfo {
        private final String name;
        private final IndexType type;

        public IndexInfo(String name, IndexType type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public IndexType type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IndexInfo other = (IndexInfo)obj;
            return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type);
        }
    }

    private static class Fields {
        final Map<String, EsField> hierarchicalMapping = new TreeMap<String, EsField>();
        final Map<String, EsField> flattedMapping = new LinkedHashMap<String, EsField>();

        private Fields() {
        }
    }
}

