/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.cat;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.common.table.TableColumnAttributeBuilder;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsStatsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

public class RestCatTrainedModelsAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return org.elasticsearch.core.List.of((Object)new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/trained_models"), (Object)new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/trained_models/{" + TrainedModelConfig.MODEL_ID + "}"));
    }

    public String getName() {
        return "cat_ml_get_trained_models_action";
    }

    protected BaseRestHandler.RestChannelConsumer doCatRequest(RestRequest restRequest, NodeClient client) {
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)modelId)) {
            modelId = "_all";
        }
        GetTrainedModelsStatsAction.Request statsRequest = new GetTrainedModelsStatsAction.Request(modelId);
        GetTrainedModelsAction.Request modelsAction = new GetTrainedModelsAction.Request(modelId, null, Collections.emptySet());
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            statsRequest.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            modelsAction.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        statsRequest.setAllowNoResources(true);
        modelsAction.setAllowNoResources(restRequest.paramAsBoolean(GetTrainedModelsAction.Request.ALLOW_NO_MATCH.getPreferredName(), statsRequest.isAllowNoResources()));
        return channel -> {
            ActionListener listener = ActionListener.notifyOnce((ActionListener)new RestResponseListener<Table>(channel){

                public RestResponse buildResponse(Table table) throws Exception {
                    return RestTable.buildResponse((Table)table, (RestChannel)this.channel);
                }
            });
            client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)modelsAction, ActionListener.wrap(trainedModels -> {
                List trainedModelConfigs = trainedModels.getResources().results();
                HashSet potentialAnalyticsIds = new HashSet();
                trainedModelConfigs.stream().filter(c -> "_xpack".equals(c.getCreatedBy())).forEach(c -> potentialAnalyticsIds.addAll(c.getTags()));
                String requestIdPattern = Strings.collectionToDelimitedString(potentialAnalyticsIds, (String)"*,") + "*";
                GroupedActionListener<ActionResponse> groupedListener = this.createGroupedListener(restRequest, 2, trainedModels.getResources().results(), (ActionListener<Table>)listener);
                client.execute((ActionType)GetTrainedModelsStatsAction.INSTANCE, (ActionRequest)statsRequest, ActionListener.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
                GetDataFrameAnalyticsAction.Request dataFrameAnalyticsRequest = new GetDataFrameAnalyticsAction.Request(requestIdPattern);
                dataFrameAnalyticsRequest.setAllowNoResources(true);
                dataFrameAnalyticsRequest.setPageParams(new PageParams(0, potentialAnalyticsIds.size()));
                client.execute((ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)dataFrameAnalyticsRequest, ActionListener.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        };
    }

    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/ml/trained_models\n");
        sb.append("/_cat/ml/trained_models/{model_id}\n");
    }

    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"id", TableColumnAttributeBuilder.builder((String)"the trained model id").build());
        table.addCell((Object)"created_by", TableColumnAttributeBuilder.builder((String)"who created the model", (boolean)false).setAliases(new String[]{"c", "createdBy"}).setTextAlignment(TableColumnAttributeBuilder.TextAlign.RIGHT).build());
        table.addCell((Object)"heap_size", TableColumnAttributeBuilder.builder((String)"the estimated heap size to keep the model in memory").setAliases(new String[]{"hs", "modelHeapSize"}).build());
        table.addCell((Object)"operations", TableColumnAttributeBuilder.builder((String)"the estimated number of operations to use the model").setAliases(new String[]{"o", "modelOperations"}).build());
        table.addCell((Object)"license", TableColumnAttributeBuilder.builder((String)"The license level of the model", (boolean)false).setAliases(new String[]{"l"}).build());
        table.addCell((Object)"create_time", TableColumnAttributeBuilder.builder((String)"The time the model was created").setAliases(new String[]{"ct"}).build());
        table.addCell((Object)"version", TableColumnAttributeBuilder.builder((String)"The version of Elasticsearch when the model was created", (boolean)false).setAliases(new String[]{"v"}).build());
        table.addCell((Object)"description", TableColumnAttributeBuilder.builder((String)"The model description", (boolean)false).setAliases(new String[]{"d"}).build());
        table.addCell((Object)"ingest.pipelines", TableColumnAttributeBuilder.builder((String)"The number of pipelines referencing the model").setAliases(new String[]{"ip", "ingestPipelines"}).build());
        table.addCell((Object)"ingest.count", TableColumnAttributeBuilder.builder((String)"The total number of docs processed by the model", (boolean)false).setAliases(new String[]{"ic", "ingestCount"}).build());
        table.addCell((Object)"ingest.time", TableColumnAttributeBuilder.builder((String)"The total time spent processing docs with this model", (boolean)false).setAliases(new String[]{"it", "ingestTime"}).build());
        table.addCell((Object)"ingest.current", TableColumnAttributeBuilder.builder((String)"The total documents currently being handled by the model", (boolean)false).setAliases(new String[]{"icurr", "ingestCurrent"}).build());
        table.addCell((Object)"ingest.failed", TableColumnAttributeBuilder.builder((String)"The total count of failed ingest attempts with this model", (boolean)false).setAliases(new String[]{"if", "ingestFailed"}).build());
        table.addCell((Object)"data_frame.id", TableColumnAttributeBuilder.builder((String)"The data frame analytics config id that created the model (if still available)").setAliases(new String[]{"dfid", "dataFrameAnalytics"}).build());
        table.addCell((Object)"data_frame.create_time", TableColumnAttributeBuilder.builder((String)"The time the data frame analytics config was created", (boolean)false).setAliases(new String[]{"dft", "dataFrameAnalyticsTime"}).build());
        table.addCell((Object)"data_frame.source_index", TableColumnAttributeBuilder.builder((String)"The source index used to train in the data frame analysis", (boolean)false).setAliases(new String[]{"dfsi", "dataFrameAnalyticsSrcIndex"}).build());
        table.addCell((Object)"data_frame.analysis", TableColumnAttributeBuilder.builder((String)"The analysis used by the data frame to build the model", (boolean)false).setAliases(new String[]{"dfa", "dataFrameAnalyticsAnalysis"}).build());
        table.endHeaders();
        return table;
    }

    private GroupedActionListener<ActionResponse> createGroupedListener(RestRequest request, int size, List<TrainedModelConfig> configs, ActionListener<Table> listener) {
        return new GroupedActionListener(listener.delegateFailure((l, responses) -> {
            GetTrainedModelsStatsAction.Response statsResponse = RestCatTrainedModelsAction.extractResponse(responses, GetTrainedModelsStatsAction.Response.class);
            GetDataFrameAnalyticsAction.Response analytics = RestCatTrainedModelsAction.extractResponse(responses, GetDataFrameAnalyticsAction.Response.class);
            l.onResponse((Object)this.buildTable(request, statsResponse.getResources().results(), configs, analytics == null ? Collections.emptyList() : analytics.getResources().results()));
        }), size);
    }

    private Table buildTable(RestRequest request, List<GetTrainedModelsStatsAction.Response.TrainedModelStats> stats, List<TrainedModelConfig> configs, List<DataFrameAnalyticsConfig> analyticsConfigs) {
        Table table = this.getTableWithHeader(request);
        assert (configs.size() == stats.size());
        Map analyticsMap = analyticsConfigs.stream().collect(Collectors.toMap(DataFrameAnalyticsConfig::getId, Function.identity()));
        Map statsMap = stats.stream().collect(Collectors.toMap(GetTrainedModelsStatsAction.Response.TrainedModelStats::getModelId, Function.identity()));
        configs.forEach(config -> {
            table.startRow();
            table.addCell((Object)config.getModelId());
            table.addCell((Object)config.getCreatedBy());
            table.addCell((Object)ByteSizeValue.ofBytes((long)config.getEstimatedHeapMemory()));
            table.addCell((Object)config.getEstimatedOperations());
            table.addCell((Object)config.getLicenseLevel());
            table.addCell((Object)config.getCreateTime());
            table.addCell((Object)config.getVersion().toString());
            table.addCell((Object)config.getDescription());
            GetTrainedModelsStatsAction.Response.TrainedModelStats modelStats = (GetTrainedModelsStatsAction.Response.TrainedModelStats)statsMap.get(config.getModelId());
            table.addCell((Object)modelStats.getPipelineCount());
            boolean hasIngestStats = modelStats != null && modelStats.getIngestStats() != null;
            table.addCell((Object)(hasIngestStats ? modelStats.getIngestStats().getTotalStats().getIngestCount() : 0L));
            table.addCell((Object)(hasIngestStats ? TimeValue.timeValueMillis((long)modelStats.getIngestStats().getTotalStats().getIngestTimeInMillis()) : TimeValue.timeValueMillis((long)0L)));
            table.addCell((Object)(hasIngestStats ? modelStats.getIngestStats().getTotalStats().getIngestCurrent() : 0L));
            table.addCell((Object)(hasIngestStats ? modelStats.getIngestStats().getTotalStats().getIngestFailedCount() : 0L));
            DataFrameAnalyticsConfig dataFrameAnalyticsConfig = config.getTags().stream().filter(analyticsMap::containsKey).map(analyticsMap::get).findFirst().orElse(null);
            table.addCell((Object)(dataFrameAnalyticsConfig == null ? "__none__" : dataFrameAnalyticsConfig.getId()));
            table.addCell((Object)(dataFrameAnalyticsConfig == null ? null : dataFrameAnalyticsConfig.getCreateTime()));
            table.addCell(dataFrameAnalyticsConfig == null ? null : Strings.arrayToCommaDelimitedString((Object[])dataFrameAnalyticsConfig.getSource().getIndex()));
            DataFrameAnalysis analysis = dataFrameAnalyticsConfig == null ? null : dataFrameAnalyticsConfig.getAnalysis();
            table.addCell((Object)(analysis == null ? null : analysis.getWriteableName()));
            table.endRow();
        });
        return table;
    }

    private static <A extends ActionResponse> A extractResponse(Collection<? extends ActionResponse> responses, Class<A> c) {
        return (A)responses.stream().filter(c::isInstance).findFirst().get();
    }
}

