/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.stats.Fields;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;
import org.elasticsearch.xpack.ml.utils.persistence.DocIdBatchedDocumentIterator;

public class UnusedStatsRemover
implements MlDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(UnusedStatsRemover.class);
    private final OriginSettingClient client;
    private final TaskId parentTaskId;

    public UnusedStatsRemover(OriginSettingClient client, TaskId parentTaskId) {
        this.client = Objects.requireNonNull(client);
        this.parentTaskId = Objects.requireNonNull(parentTaskId);
    }

    @Override
    public void remove(float requestsPerSec, ActionListener<Boolean> listener, Supplier<Boolean> isTimedOutSupplier) {
        try {
            if (isTimedOutSupplier.get().booleanValue()) {
                listener.onResponse((Object)false);
                return;
            }
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)Fields.JOB_ID.getPreferredName(), this.getDataFrameAnalyticsJobIds())).mustNot((QueryBuilder)QueryBuilders.termsQuery((String)TrainedModelConfig.MODEL_ID.getPreferredName(), this.getTrainedModelIds()));
            if (isTimedOutSupplier.get().booleanValue()) {
                listener.onResponse((Object)false);
                return;
            }
            this.executeDeleteUnusedStatsDocs((QueryBuilder)queryBuilder, requestsPerSec, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private Set<String> getDataFrameAnalyticsJobIds() {
        HashSet<String> jobIds = new HashSet<String>();
        DocIdBatchedDocumentIterator iterator = new DocIdBatchedDocumentIterator(this.client, MlConfigIndex.indexName(), (QueryBuilder)QueryBuilders.termQuery((String)DataFrameAnalyticsConfig.CONFIG_TYPE.getPreferredName(), (String)"data_frame_analytics_config"));
        while (iterator.hasNext()) {
            Deque docIds = iterator.next();
            docIds.stream().map(DataFrameAnalyticsConfig::extractJobIdFromDocId).filter(Objects::nonNull).forEach(jobIds::add);
        }
        return jobIds;
    }

    private Set<String> getTrainedModelIds() {
        HashSet<String> modelIds = new HashSet<String>(TrainedModelProvider.MODELS_STORED_AS_RESOURCE);
        DocIdBatchedDocumentIterator iterator = new DocIdBatchedDocumentIterator(this.client, ".ml-inference-*", (QueryBuilder)QueryBuilders.termQuery((String)InferenceIndexConstants.DOC_TYPE.getPreferredName(), (String)"trained_model_config"));
        while (iterator.hasNext()) {
            Deque docIds = iterator.next();
            docIds.stream().filter(Objects::nonNull).forEach(modelIds::add);
        }
        return modelIds;
    }

    private void executeDeleteUnusedStatsDocs(QueryBuilder dbq, float requestsPerSec, ActionListener<Boolean> listener) {
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{MlStatsIndex.indexPattern()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setAbortOnVersionConflict(false)).setRequestsPerSecond(requestsPerSec)).setTimeout(DEFAULT_MAX_DURATION)).setQuery(dbq);
        deleteByQueryRequest.setParentTask(this.parentTaskId);
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, ActionListener.wrap(response -> {
            if (response.getBulkFailures().size() > 0 || response.getSearchFailures().size() > 0) {
                LOGGER.error("Some unused stats documents could not be deleted due to failures: {}", (Object)(Strings.collectionToCommaDelimitedString((Iterable)response.getBulkFailures()) + "," + Strings.collectionToCommaDelimitedString((Iterable)response.getSearchFailures())));
            } else {
                LOGGER.info("Successfully deleted [{}] unused stats documents", (Object)response.getDeleted());
            }
            listener.onResponse((Object)true);
        }, e -> {
            LOGGER.error("Error deleting unused model stats documents: ", (Throwable)e);
            listener.onFailure(e);
        }));
    }
}

