/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessConfig;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;

public class AnalyticsBuilder {
    public static final String ANALYTICS = "data_frame_analyzer";
    private static final String ANALYTICS_PATH = "./data_frame_analyzer";
    private static final String LENGTH_ENCODED_INPUT_ARG = "--lengthEncodedInput";
    private static final String CONFIG_ARG = "--config=";
    private static final String MEMORY_USAGE_ESTIMATION_ONLY_ARG = "--memoryUsageEstimationOnly";
    private static final String LICENSE_KEY_VALIDATED_ARG = "--validElasticLicenseKeyConfirmed=";
    private final Supplier<Path> tempDirPathSupplier;
    private final NativeController nativeController;
    private final ProcessPipes processPipes;
    private final AnalyticsProcessConfig config;
    private final List<Path> filesToDelete;
    private boolean performMemoryUsageEstimationOnly;

    public AnalyticsBuilder(Supplier<Path> tempDirPathSupplier, NativeController nativeController, ProcessPipes processPipes, AnalyticsProcessConfig config, List<Path> filesToDelete) {
        this.tempDirPathSupplier = Objects.requireNonNull(tempDirPathSupplier);
        this.nativeController = Objects.requireNonNull(nativeController);
        this.processPipes = Objects.requireNonNull(processPipes);
        this.config = Objects.requireNonNull(config);
        this.filesToDelete = Objects.requireNonNull(filesToDelete);
    }

    public AnalyticsBuilder performMemoryUsageEstimationOnly() {
        this.performMemoryUsageEstimationOnly = true;
        return this;
    }

    public void build() throws IOException, InterruptedException {
        List<String> command = this.buildAnalyticsCommand();
        this.processPipes.addArgs(command);
        this.nativeController.startProcess(command);
    }

    private List<String> buildAnalyticsCommand() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(ANALYTICS_PATH);
        command.add(LENGTH_ENCODED_INPUT_ARG);
        this.addConfigFile(command);
        if (this.performMemoryUsageEstimationOnly) {
            command.add(MEMORY_USAGE_ESTIMATION_ONLY_ARG);
        }
        command.add("--validElasticLicenseKeyConfirmed=true");
        return command;
    }

    private void addConfigFile(List<String> command) throws IOException {
        Path tempDir = this.tempDirPathSupplier.get();
        Path configFile = Files.createTempFile(tempDir, "analysis", ".conf", new FileAttribute[0]);
        this.filesToDelete.add(configFile);
        try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(configFile, new OpenOption[0]), StandardCharsets.UTF_8);
             XContentBuilder jsonBuilder = JsonXContent.contentBuilder();){
            this.config.toXContent(jsonBuilder, ToXContent.EMPTY_PARAMS);
            osw.write(Strings.toString((XContentBuilder)jsonBuilder));
        }
        command.add(CONFIG_ARG + configFile.toString());
    }
}

