/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class PutSamlServiceProviderResponse
extends ActionResponse
implements ToXContentObject {
    private final String docId;
    private final boolean created;
    private final long seqNo;
    private final long primaryTerm;
    private final String entityId;
    private final boolean enabled;

    public PutSamlServiceProviderResponse(String docId, boolean created, long seqNo, long primaryTerm, String entityId, boolean enabled) {
        this.docId = Objects.requireNonNull(docId, "Document Id cannot be null");
        this.created = created;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.entityId = Objects.requireNonNull(entityId, "Entity Id cannot be null");
        this.enabled = enabled;
    }

    public PutSamlServiceProviderResponse(StreamInput in) throws IOException {
        this.docId = in.readString();
        this.created = in.readBoolean();
        this.seqNo = in.readZLong();
        this.primaryTerm = in.readVLong();
        this.entityId = in.readString();
        this.enabled = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.docId);
        out.writeBoolean(this.created);
        out.writeZLong(this.seqNo);
        out.writeVLong(this.primaryTerm);
        out.writeString(this.entityId);
        out.writeBoolean(this.enabled);
    }

    public String getDocId() {
        return this.docId;
    }

    public boolean isCreated() {
        return this.created;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("document");
        builder.field("_id", this.docId);
        builder.field("_created", this.created);
        builder.field("_seq_no", this.seqNo);
        builder.field("_primary_term", this.primaryTerm);
        builder.endObject();
        builder.startObject("service_provider");
        builder.field("entity_id", this.entityId);
        builder.field("enabled", this.enabled);
        builder.endObject();
        return builder.endObject();
    }
}

