/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;

public class DeleteSamlServiceProviderResponse
extends ActionResponse
implements ToXContentObject {
    private final String docId;
    private final long seqNo;
    private final long primaryTerm;
    private final String entityId;

    public DeleteSamlServiceProviderResponse(String docId, long seqNo, long primaryTerm, String entityId) {
        this.docId = docId;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.entityId = Objects.requireNonNull(entityId, "Entity Id cannot be null");
    }

    public DeleteSamlServiceProviderResponse(DeleteResponse deleteResponse, String entityId) {
        this(deleteResponse == null ? null : deleteResponse.getId(), deleteResponse == null ? -2L : deleteResponse.getSeqNo(), deleteResponse == null ? 0L : deleteResponse.getPrimaryTerm(), entityId);
    }

    public DeleteSamlServiceProviderResponse(StreamInput in) throws IOException {
        this.docId = in.readString();
        this.seqNo = in.readZLong();
        this.primaryTerm = in.readVLong();
        this.entityId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.docId);
        out.writeZLong(this.seqNo);
        out.writeVLong(this.primaryTerm);
        out.writeString(this.entityId);
    }

    @Nullable
    public String getDocId() {
        return this.docId;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("document");
        builder.field("_id", this.docId);
        builder.field("_seq_no", this.seqNo);
        builder.field("_primary_term", this.primaryTerm);
        builder.endObject();
        builder.startObject("service_provider");
        builder.field("entity_id", this.entityId);
        builder.endObject();
        return builder.endObject();
    }

    public boolean found() {
        return this.docId != null;
    }
}

