/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.launchers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class JvmOption {
    private final String value;
    private final String origin;
    private static final Pattern OPTION = Pattern.compile("^\\s*\\S+\\s+(?<flag>\\S+)\\s+:?=\\s+(?<value>\\S+)?\\s+\\{[^}]+?\\}(\\s+\\{(?<origin>[^}]+)})?");

    JvmOption(String value, String origin) {
        this.value = value;
        this.origin = origin;
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public String getMandatoryValue() {
        return this.value;
    }

    public boolean isCommandLineOrigin() {
        return "command line".equals(this.origin);
    }

    public static Long extractMaxHeapSize(Map<String, JvmOption> finalJvmOptions) {
        return Long.parseLong(finalJvmOptions.get("MaxHeapSize").getMandatoryValue());
    }

    public static boolean isMaxHeapSpecified(Map<String, JvmOption> finalJvmOptions) {
        JvmOption maxHeapSize = finalJvmOptions.get("MaxHeapSize");
        return maxHeapSize != null && maxHeapSize.isCommandLineOrigin();
    }

    public static boolean isMinHeapSpecified(Map<String, JvmOption> finalJvmOptions) {
        JvmOption minHeapSize = finalJvmOptions.get("MinHeapSize");
        return minHeapSize != null && minHeapSize.isCommandLineOrigin();
    }

    public static boolean isInitialHeapSpecified(Map<String, JvmOption> finalJvmOptions) {
        JvmOption initialHeapSize = finalJvmOptions.get("InitialHeapSize");
        return initialHeapSize != null && initialHeapSize.isCommandLineOrigin();
    }

    public static long extractMaxDirectMemorySize(Map<String, JvmOption> finalJvmOptions) {
        return Long.parseLong(finalJvmOptions.get("MaxDirectMemorySize").getMandatoryValue());
    }

    public static Map<String, JvmOption> findFinalOptions(List<String> userDefinedJvmOptions) throws InterruptedException, IOException {
        return Collections.unmodifiableMap(JvmOption.flagsFinal(userDefinedJvmOptions).stream().map(OPTION::matcher).filter(Matcher::matches).collect(Collectors.toMap(m -> m.group("flag"), m -> new JvmOption(m.group("value"), m.group("origin")))));
    }

    private static List<String> flagsFinal(List<String> userDefinedJvmOptions) throws InterruptedException, IOException {
        String java = Paths.get(System.getProperty("java.home"), "bin", "java").toString();
        List<String> command = Collections.unmodifiableList(Stream.of(Stream.of(java), userDefinedJvmOptions.stream(), Stream.of("-Xshare:off"), Stream.of("-XX:+PrintFlagsFinal"), Stream.of("-version")).reduce(Stream::concat).get().collect(Collectors.toList()));
        Process process = new ProcessBuilder(new String[0]).command(command).start();
        List<String> output = JvmOption.readLinesFromInputStream(process.getInputStream());
        List<String> error = JvmOption.readLinesFromInputStream(process.getErrorStream());
        int status = process.waitFor();
        if (status != 0) {
            String message = String.format(Locale.ROOT, "starting java failed with [%d]\noutput:\n%s\nerror:\n%s", status, String.join((CharSequence)"\n", output), String.join((CharSequence)"\n", error));
            throw new RuntimeException(message);
        }
        return output;
    }

    private static List<String> readLinesFromInputStream(InputStream is) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
            List<String> list;
            try (BufferedReader br = new BufferedReader(isr);){
                list = Collections.unmodifiableList(br.lines().collect(Collectors.toList()));
            }
            return list;
        }
    }
}

