/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.symbol;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class WriteScope {
    protected final WriteScope parent;
    protected final ClassWriter classWriter;
    protected final MethodWriter methodWriter;
    protected final Label continueLabel;
    protected final Label breakLabel;
    protected final Label tryBeginLabel;
    protected final Label tryEndLabel;
    protected final Label catchesEndLabel;
    protected final Map<String, Variable> variables = new HashMap<String, Variable>();
    protected int nextSlot;

    protected WriteScope() {
        this.parent = null;
        this.classWriter = null;
        this.methodWriter = null;
        this.continueLabel = null;
        this.breakLabel = null;
        this.tryBeginLabel = null;
        this.tryEndLabel = null;
        this.catchesEndLabel = null;
        this.nextSlot = 0;
    }

    protected WriteScope(WriteScope parent, ClassWriter classWriter) {
        this.parent = parent;
        this.classWriter = classWriter;
        this.methodWriter = parent.methodWriter;
        this.continueLabel = parent.continueLabel;
        this.breakLabel = parent.breakLabel;
        this.tryBeginLabel = parent.tryBeginLabel;
        this.tryEndLabel = parent.tryEndLabel;
        this.catchesEndLabel = parent.catchesEndLabel;
        this.nextSlot = parent.nextSlot;
    }

    protected WriteScope(WriteScope parent, MethodWriter methodWriter) {
        this.parent = parent;
        this.classWriter = parent.classWriter;
        this.methodWriter = methodWriter;
        this.continueLabel = parent.continueLabel;
        this.breakLabel = parent.breakLabel;
        this.tryBeginLabel = parent.tryBeginLabel;
        this.tryEndLabel = parent.tryEndLabel;
        this.catchesEndLabel = parent.catchesEndLabel;
        this.nextSlot = parent.nextSlot;
    }

    protected WriteScope(WriteScope parent, Label continueLabel, Label breakLabel) {
        this.parent = parent;
        this.classWriter = parent.classWriter;
        this.methodWriter = parent.methodWriter;
        this.continueLabel = continueLabel;
        this.breakLabel = breakLabel;
        this.tryBeginLabel = parent.tryBeginLabel;
        this.tryEndLabel = parent.tryEndLabel;
        this.catchesEndLabel = parent.catchesEndLabel;
        this.nextSlot = parent.nextSlot;
    }

    protected WriteScope(WriteScope parent, Label tryBeginLabel, Label tryEndLabel, Label catchesEndLabel) {
        this.parent = parent;
        this.classWriter = parent.classWriter;
        this.methodWriter = parent.methodWriter;
        this.continueLabel = parent.continueLabel;
        this.breakLabel = parent.breakLabel;
        this.tryBeginLabel = tryBeginLabel;
        this.tryEndLabel = tryEndLabel;
        this.catchesEndLabel = catchesEndLabel;
        this.nextSlot = parent.nextSlot;
    }

    protected WriteScope(WriteScope parent, boolean isTryBlock) {
        this.parent = parent;
        this.classWriter = parent.classWriter;
        this.methodWriter = parent.methodWriter;
        this.continueLabel = parent.continueLabel;
        this.breakLabel = parent.breakLabel;
        this.tryBeginLabel = isTryBlock ? null : parent.tryBeginLabel;
        this.tryEndLabel = isTryBlock ? null : parent.tryEndLabel;
        this.catchesEndLabel = isTryBlock ? null : parent.catchesEndLabel;
        this.nextSlot = parent.nextSlot;
    }

    public static WriteScope newScriptScope() {
        return new WriteScope();
    }

    public WriteScope newClassScope(ClassWriter classWriter) {
        return new WriteScope(this, classWriter);
    }

    public WriteScope newMethodScope(MethodWriter methodWriter) {
        return new WriteScope(this, methodWriter);
    }

    public WriteScope newLoopScope(Label continueLabel, Label breakLabel) {
        return new WriteScope(this, continueLabel, breakLabel);
    }

    public WriteScope newTryScope(Label tryBeginLabel, Label tryEndLabel, Label catchesEndLabel) {
        return new WriteScope(this, tryBeginLabel, tryEndLabel, catchesEndLabel);
    }

    public WriteScope newBlockScope(boolean isTryBlock) {
        return new WriteScope(this, isTryBlock);
    }

    public WriteScope newBlockScope() {
        return this.newBlockScope(false);
    }

    public ClassWriter getClassWriter() {
        return this.classWriter;
    }

    public MethodWriter getMethodWriter() {
        return this.methodWriter;
    }

    public Label getContinueLabel() {
        return this.continueLabel;
    }

    public Label getBreakLabel() {
        return this.breakLabel;
    }

    public Label getTryBeginLabel() {
        return this.tryBeginLabel;
    }

    public Label getTryEndLabel() {
        return this.tryEndLabel;
    }

    public Label getCatchesEndLabel() {
        return this.catchesEndLabel;
    }

    public Variable defineVariable(Class<?> type, String name) {
        Variable variable = new Variable(type, name, this.nextSlot);
        this.nextSlot += variable.getAsmType().getSize();
        this.variables.put(name, variable);
        return variable;
    }

    public Variable defineInternalVariable(Class<?> type, String name) {
        return this.defineVariable(type, "#" + name);
    }

    public Variable getVariable(String name) {
        Variable variable = this.variables.get(name);
        if (variable == null && this.parent != null) {
            variable = this.parent.getVariable(name);
        }
        return variable;
    }

    public Variable getInternalVariable(String name) {
        return this.getVariable("#" + name);
    }

    public static class Variable {
        protected final Class<?> type;
        protected final Type asmType;
        protected final String name;
        protected final int slot;

        public Variable(Class<?> type, String name, int slot) {
            this.type = type;
            this.asmType = MethodWriter.getType(type);
            this.name = name;
            this.slot = slot;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.type);
        }

        public Type getAsmType() {
            return this.asmType;
        }

        public String getName() {
            return this.name;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

