/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsUtils;
import org.elasticsearch.xpack.searchablesnapshots.cache.blob.BlobStoreCacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.blob.CachedBlob;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.ByteRange;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheFile;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheKey;
import org.elasticsearch.xpack.searchablesnapshots.store.IndexInputStats;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;
import org.elasticsearch.xpack.searchablesnapshots.store.input.BaseSearchableSnapshotIndexInput;

public abstract class MetadataCachingIndexInput
extends BaseSearchableSnapshotIndexInput {
    protected static final int COPY_BUFFER_SIZE = ByteSizeUnit.KB.toIntBytes(8L);
    protected final CacheFileReference cacheFileReference;
    protected final long compoundFileOffset;
    protected final int defaultRangeSize;
    protected final int recoveryRangeSize;
    protected long lastReadPosition;
    protected long lastSeekPosition;

    public MetadataCachingIndexInput(Logger logger, String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long compoundFileOffset, long length, CacheFileReference cacheFileReference, int defaultRangeSize, int recoveryRangeSize, ByteRange headerBlobCacheByteRange, ByteRange footerBlobCacheByteRange) {
        super(logger, name, directory, fileInfo, context, stats, offset, length, headerBlobCacheByteRange, footerBlobCacheByteRange);
        this.cacheFileReference = cacheFileReference;
        this.compoundFileOffset = compoundFileOffset;
        this.defaultRangeSize = defaultRangeSize;
        this.recoveryRangeSize = recoveryRangeSize;
        this.lastReadPosition = offset;
        this.lastSeekPosition = offset;
        assert (offset >= compoundFileOffset);
        assert (this.getBufferSize() <= BlobStoreCacheService.DEFAULT_CACHED_BLOB_SIZE);
    }

    @Override
    protected void doReadInternal(ByteBuffer b) throws IOException {
        int length;
        long position;
        block4: {
            position = this.getAbsolutePosition();
            length = b.remaining();
            this.logger.trace("readInternal: read [{}-{}] ([{}] bytes) from [{}]", (Object)position, (Object)(position + (long)length), (Object)length, (Object)this);
            try {
                ByteRange blobCacheByteRange = this.rangeToReadFromBlobCache(position, length);
                if (blobCacheByteRange.isEmpty()) {
                    this.readWithoutBlobCache(b);
                } else {
                    this.readWithBlobCache(b, blobCacheByteRange);
                }
            }
            catch (Exception e) {
                int alreadyRead = length - b.remaining();
                int bytesRead = this.readDirectlyIfAlreadyClosed(position + (long)alreadyRead, b, e);
                if ($assertionsDisabled || alreadyRead + bytesRead == length) break block4;
                throw new AssertionError((Object)(alreadyRead + " + " + bytesRead + " vs " + length));
            }
        }
        this.readComplete(position, length);
    }

    protected abstract void readWithoutBlobCache(ByteBuffer var1) throws Exception;

    private void readWithBlobCache(ByteBuffer b, ByteRange blobCacheByteRange) throws Exception {
        long position = this.getAbsolutePosition();
        int length = b.remaining();
        CacheFile cacheFile = this.cacheFileReference.get();
        Future<Integer> waitingForRead = cacheFile.readIfAvailableOrPending(ByteRange.of(position, position + (long)length), chan -> {
            int read = this.readCacheFile(chan, position, b);
            assert (read == length) : read + " vs " + length;
            return read;
        });
        if (waitingForRead != null) {
            Integer read = waitingForRead.get();
            assert (read == length);
            return;
        }
        CachedBlob cachedBlob = this.directory.getCachedBlob(this.fileInfo.physicalName(), blobCacheByteRange);
        assert (cachedBlob == CachedBlob.CACHE_MISS || cachedBlob == CachedBlob.CACHE_NOT_READY || cachedBlob.from() <= position);
        assert (cachedBlob == CachedBlob.CACHE_MISS || cachedBlob == CachedBlob.CACHE_NOT_READY || length <= cachedBlob.length());
        if (cachedBlob == CachedBlob.CACHE_MISS || cachedBlob == CachedBlob.CACHE_NOT_READY) {
            ByteRange rangeToWrite = blobCacheByteRange;
            ByteRange rangeToRead = ByteRange.of(position, position + (long)length);
            assert (rangeToRead.isSubRangeOf(rangeToWrite)) : rangeToRead + " vs " + rangeToWrite;
            assert (rangeToRead.length() == (long)b.remaining()) : b.remaining() + " vs " + rangeToRead;
            Future<Integer> populateCacheFuture = cacheFile.populateAndRead(rangeToWrite, rangeToRead, channel -> this.readCacheFile(channel, position, b), this::writeCacheFile, this.directory.cacheFetchAsyncExecutor());
            this.fillIndexCache(cacheFile, blobCacheByteRange);
            if (this.compoundFileOffset > 0L && blobCacheByteRange.equals(this.headerBlobCacheByteRange) && !this.footerBlobCacheByteRange.isEmpty()) {
                this.fillIndexCache(cacheFile, this.footerBlobCacheByteRange);
            }
            int bytesRead = populateCacheFuture.get();
            assert (bytesRead == length) : bytesRead + " vs " + length;
        } else {
            BytesRef bytesRef;
            this.logger.trace("reading [{}] bytes of file [{}] at position [{}] using cache index", (Object)length, (Object)this.fileInfo.physicalName(), (Object)position);
            int sliceOffset = SearchableSnapshotsUtils.toIntBytes(position - cachedBlob.from());
            BytesRefIterator cachedBytesIterator = cachedBlob.bytes().slice(sliceOffset, length).iterator();
            int copiedBytes = 0;
            while ((bytesRef = cachedBytesIterator.next()) != null) {
                b.put(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                copiedBytes += bytesRef.length;
            }
            assert (copiedBytes == length) : "copied " + copiedBytes + " but expected " + length;
            this.stats.addIndexCacheBytesRead(cachedBlob.length());
            try {
                ByteRange cachedRange = ByteRange.of(cachedBlob.from(), cachedBlob.to());
                cacheFile.populateAndRead(cachedRange, cachedRange, channel -> cachedBlob.length(), (channel, from, to, progressUpdater) -> {
                    BytesRef current;
                    long startTimeNanos = this.stats.currentTimeNanos();
                    BytesRefIterator iterator = cachedBlob.bytes().slice(SearchableSnapshotsUtils.toIntBytes(from - cachedBlob.from()), SearchableSnapshotsUtils.toIntBytes(to - from)).iterator();
                    long writePosition = from;
                    while ((current = iterator.next()) != null) {
                        ByteBuffer byteBuffer = ByteBuffer.wrap(current.bytes, current.offset, current.length);
                        while (byteBuffer.remaining() > 0) {
                            writePosition += (long)MetadataCachingIndexInput.positionalWrite(channel, writePosition, byteBuffer);
                            progressUpdater.accept(writePosition);
                        }
                    }
                    assert (writePosition == to) : writePosition + " vs " + to;
                    long endTimeNanos = this.stats.currentTimeNanos();
                    this.stats.addCachedBytesWritten(to - from, endTimeNanos - startTimeNanos);
                    this.logger.trace("copied bytes [{}-{}] of file [{}] from cache index to disk", (Object)from, (Object)to, (Object)this.fileInfo);
                }, this.directory.cacheFetchAsyncExecutor());
            }
            catch (Exception e) {
                this.logger.debug((Message)new ParameterizedMessage("failed to store bytes [{}-{}] of file [{}] obtained from index cache", new Object[]{cachedBlob.from(), cachedBlob.to(), this.fileInfo}), (Throwable)e);
            }
        }
    }

    private void readComplete(long position, int length) {
        this.stats.incrementBytesRead(this.lastReadPosition, position, length);
        this.lastSeekPosition = this.lastReadPosition = position + (long)length;
    }

    protected int readCacheFile(FileChannel fc, long position, ByteBuffer buffer) throws IOException {
        assert (MetadataCachingIndexInput.assertFileChannelOpen(fc));
        int bytesRead = Channels.readFromFileChannel((FileChannel)fc, (long)position, (ByteBuffer)buffer);
        if (bytesRead == -1) {
            throw new EOFException(String.format(Locale.ROOT, "unexpected EOF reading [%d-%d] from %s", position, position + (long)buffer.remaining(), this.cacheFileReference));
        }
        this.stats.addCachedBytesRead(bytesRead);
        return bytesRead;
    }

    protected void writeCacheFile(FileChannel fc, long start, long end, Consumer<Long> progressUpdater) throws IOException {
        assert (MetadataCachingIndexInput.assertFileChannelOpen(fc));
        assert (MetadataCachingIndexInput.assertCurrentThreadMayWriteCacheFile());
        long length = end - start;
        byte[] copyBuffer = new byte[SearchableSnapshotsUtils.toIntBytes(Math.min((long)COPY_BUFFER_SIZE, length))];
        this.logger.trace(() -> new ParameterizedMessage("writing range [{}-{}] to cache file [{}]", new Object[]{start, end, this.cacheFileReference}));
        long bytesCopied = 0L;
        long startTimeNanos = this.stats.currentTimeNanos();
        try (InputStream input = this.openInputStreamFromBlobStore(start, length);){
            int bytesRead;
            for (long remaining = end - start; remaining > 0L; remaining -= (long)bytesRead) {
                bytesRead = MetadataCachingIndexInput.readSafe(input, copyBuffer, start, end, remaining, this.cacheFileReference);
                MetadataCachingIndexInput.positionalWrite(fc, start + bytesCopied, ByteBuffer.wrap(copyBuffer, 0, bytesRead));
                progressUpdater.accept(start + (bytesCopied += (long)bytesRead));
            }
            long endTimeNanos = this.stats.currentTimeNanos();
            this.stats.addCachedBytesWritten(bytesCopied, endTimeNanos - startTimeNanos);
        }
    }

    private void fillIndexCache(CacheFile cacheFile, ByteRange indexCacheMiss) {
        final Releasable onCacheFillComplete = this.stats.addIndexCacheFill();
        Future<Integer> readFuture = cacheFile.readIfAvailableOrPending(indexCacheMiss, channel -> {
            int indexCacheMissLength = SearchableSnapshotsUtils.toIntBytes(indexCacheMiss.length());
            ByteBuffer byteBuffer = ByteBuffer.allocate(indexCacheMissLength);
            Channels.readFromFileChannelWithEofException((FileChannel)channel, (long)indexCacheMiss.start(), (ByteBuffer)byteBuffer);
            byteBuffer.flip();
            BytesReference content = BytesReference.fromByteBuffer((ByteBuffer)byteBuffer);
            this.directory.putCachedBlob(this.fileInfo.physicalName(), indexCacheMiss.start(), content, new ActionListener<Void>(){

                public void onResponse(Void response) {
                    onCacheFillComplete.close();
                }

                public void onFailure(Exception e1) {
                    onCacheFillComplete.close();
                }
            });
            return indexCacheMissLength;
        });
        if (readFuture == null) {
            onCacheFillComplete.close();
        }
    }

    protected static int readSafe(InputStream inputStream, byte[] copyBuffer, long rangeStart, long rangeEnd, long remaining, CacheFileReference cacheFileReference) throws IOException {
        int len = remaining < (long)copyBuffer.length ? SearchableSnapshotsUtils.toIntBytes(remaining) : copyBuffer.length;
        int bytesRead = inputStream.read(copyBuffer, 0, len);
        if (bytesRead == -1) {
            throw new EOFException(String.format(Locale.ROOT, "unexpected EOF reading [%d-%d] ([%d] bytes remaining) from %s", rangeStart, rangeEnd, remaining, cacheFileReference));
        }
        assert (bytesRead > 0) : bytesRead;
        return bytesRead;
    }

    protected static boolean assertFileChannelOpen(FileChannel fileChannel) {
        assert (fileChannel != null);
        assert (fileChannel.isOpen());
        return true;
    }

    @SuppressForbidden(reason="Use positional writes on purpose")
    protected static int positionalWrite(FileChannel fc, long start, ByteBuffer byteBuffer) throws IOException {
        assert (MetadataCachingIndexInput.assertCurrentThreadMayWriteCacheFile());
        return fc.write(byteBuffer, start);
    }

    protected static boolean assertCurrentThreadMayWriteCacheFile() {
        String threadName = Thread.currentThread().getName();
        assert (MetadataCachingIndexInput.isCacheFetchAsyncThread(threadName)) : "expected the current thread [" + threadName + "] to belong to the cache fetch async thread pool";
        return true;
    }

    protected int readDirectlyIfAlreadyClosed(long position, ByteBuffer b, Exception e) throws IOException {
        if (e instanceof AlreadyClosedException || e.getCause() != null && e.getCause() instanceof AlreadyClosedException) {
            try {
                long length = b.remaining();
                byte[] copyBuffer = new byte[SearchableSnapshotsUtils.toIntBytes(Math.min((long)COPY_BUFFER_SIZE, length))];
                this.logger.trace(() -> new ParameterizedMessage("direct reading of range [{}-{}] for cache file [{}]", new Object[]{position, position + length, this.cacheFileReference}));
                int bytesCopied = 0;
                long startTimeNanos = this.stats.currentTimeNanos();
                try (InputStream input = this.openInputStreamFromBlobStore(position, length);){
                    long remaining = length;
                    while (remaining > 0L) {
                        int len = remaining < (long)copyBuffer.length ? (int)remaining : copyBuffer.length;
                        int bytesRead = input.read(copyBuffer, 0, len);
                        if (bytesRead == -1) {
                            throw new EOFException(String.format(Locale.ROOT, "unexpected EOF reading [%d-%d] ([%d] bytes remaining) from %s", position, position + length, remaining, this.cacheFileReference));
                        }
                        b.put(copyBuffer, 0, bytesRead);
                        bytesCopied += bytesRead;
                        assert ((remaining -= (long)bytesRead) == (long)b.remaining()) : remaining + " vs " + b.remaining();
                    }
                    long endTimeNanos = this.stats.currentTimeNanos();
                    this.stats.addDirectBytesRead(bytesCopied, endTimeNanos - startTimeNanos);
                }
                return bytesCopied;
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
        }
        throw new IOException("failed to read data from cache", e);
    }

    protected abstract long getDefaultRangeSize();

    protected ByteRange computeRange(long position) {
        long rangeSize = this.getDefaultRangeSize();
        long start = position / rangeSize * rangeSize;
        long end = Math.min(start + rangeSize, this.fileInfo.length());
        return ByteRange.of(start, end);
    }

    protected void seekInternal(long pos) throws IOException {
        if (pos > this.length()) {
            throw new EOFException("Reading past end of file [position=" + pos + ", length=" + this.length() + "] for " + this.toString());
        }
        if (pos < 0L) {
            throw new IOException("Seeking to negative position [" + pos + "] for " + this.toString());
        }
        long position = pos + this.offset;
        this.stats.incrementSeeks(this.lastSeekPosition, position);
        this.lastSeekPosition = position;
    }

    @Override
    public void doClose() {
        if (!this.isClone) {
            this.cacheFileReference.releaseOnClose();
        }
    }

    static class CacheFileReference
    implements CacheFile.EvictionListener {
        private final long fileLength;
        private final CacheKey cacheKey;
        private final SearchableSnapshotDirectory directory;
        final AtomicReference<CacheFile> cacheFile = new AtomicReference();

        CacheFileReference(SearchableSnapshotDirectory directory, String fileName, long fileLength) {
            this.cacheKey = directory.createCacheKey(fileName);
            this.fileLength = fileLength;
            this.directory = directory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CacheFile get() throws Exception {
            CacheFile currentCacheFile = this.cacheFile.get();
            if (currentCacheFile != null) {
                return currentCacheFile;
            }
            CacheFile newCacheFile = this.directory.getCacheFile(this.cacheKey, this.fileLength);
            CacheFileReference cacheFileReference = this;
            synchronized (cacheFileReference) {
                currentCacheFile = this.cacheFile.get();
                if (currentCacheFile != null) {
                    return currentCacheFile;
                }
                newCacheFile.acquire(this);
                CacheFile previousCacheFile = this.cacheFile.getAndSet(newCacheFile);
                assert (previousCacheFile == null);
                return newCacheFile;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEviction(CacheFile evictedCacheFile) {
            CacheFileReference cacheFileReference = this;
            synchronized (cacheFileReference) {
                if (this.cacheFile.compareAndSet(evictedCacheFile, null)) {
                    evictedCacheFile.release(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseOnClose() {
            CacheFileReference cacheFileReference = this;
            synchronized (cacheFileReference) {
                CacheFile currentCacheFile = this.cacheFile.getAndSet(null);
                if (currentCacheFile != null) {
                    currentCacheFile.release(this);
                }
            }
        }

        public String toString() {
            return "CacheFileReference{cacheKey='" + this.cacheKey + '\'' + ", fileLength=" + this.fileLength + ", acquired=" + (this.cacheFile.get() != null) + '}';
        }
    }
}

