/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

class StageToKeys
implements Accountable {
    private final List<Set<SequenceKey>> stageToKey;

    StageToKeys(int stages) {
        this.stageToKey = Arrays.asList(new Set[stages]);
    }

    void add(int stage, SequenceKey key) {
        Set<SequenceKey> set = this.stageToKey.get(stage);
        if (set == null) {
            set = new LinkedHashSet<SequenceKey>();
            this.stageToKey.set(stage, set);
        }
        set.add(key);
    }

    void remove(int stage, SequenceKey key) {
        Set<SequenceKey> set = this.stageToKey.get(stage);
        if (set != null) {
            set.remove(key);
        }
    }

    boolean isEmpty(int stage) {
        Set<SequenceKey> set = this.stageToKey.get(stage);
        return set == null || set.isEmpty();
    }

    Set<SequenceKey> keys(int stage) {
        Set<SequenceKey> set = this.stageToKey.get(stage);
        return set == null ? Collections.emptySet() : set;
    }

    Set<SequenceKey> keys() {
        LinkedHashSet<SequenceKey> keys = new LinkedHashSet<SequenceKey>();
        for (Set<SequenceKey> sequenceKeys : this.stageToKey) {
            if (CollectionUtils.isEmpty(sequenceKeys)) continue;
            keys.addAll(sequenceKeys);
        }
        return keys;
    }

    void clear() {
        for (Set<SequenceKey> set : this.stageToKey) {
            if (set == null) continue;
            set.clear();
        }
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOfCollection(this.stageToKey);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(",", "[", "]");
        this.stageToKey.forEach(s -> sj.add(s != null ? "" + s.size() : "0"));
        return sj.toString();
    }
}

