/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.shutdown.PutShutdownNodeAction;

public class RestPutShutdownNodeAction
extends BaseRestHandler {
    public String getName() {
        return "put_shutdown_node";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_nodes/{nodeId}/shutdown"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String nodeId = request.param("nodeId");
        try (XContentParser parser = request.contentParser();){
            PutShutdownNodeAction.Request parsedRequest = PutShutdownNodeAction.Request.parseRequest(nodeId, parser);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)PutShutdownNodeAction.INSTANCE, (ActionRequest)parsedRequest, (ActionListener)new RestToXContentListener(channel));
            return restChannelConsumer;
        }
    }
}

