/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.action;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkDoc;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkRequest;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkResponse;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.MonitoringService;
import org.elasticsearch.xpack.monitoring.exporter.BytesReferenceMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;

public class TransportMonitoringBulkAction
extends HandledTransportAction<MonitoringBulkRequest, MonitoringBulkResponse> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Exporters exportService;
    private final MonitoringService monitoringService;

    @Inject
    public TransportMonitoringBulkAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Exporters exportService, MonitoringService monitoringService) {
        super("cluster:admin/xpack/monitoring/bulk", transportService, actionFilters, MonitoringBulkRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.exportService = exportService;
        this.monitoringService = monitoringService;
    }

    protected void doExecute(Task task, MonitoringBulkRequest request, ActionListener<MonitoringBulkResponse> listener) {
        this.clusterService.state().blocks().globalBlockedRaiseException(ClusterBlockLevel.WRITE);
        if (!this.monitoringService.isMonitoringActive()) {
            listener.onResponse((Object)new MonitoringBulkResponse(0L, true));
            return;
        }
        long timestamp = System.currentTimeMillis();
        String cluster = this.clusterService.state().metadata().clusterUUID();
        DiscoveryNode discoveryNode = this.clusterService.localNode();
        MonitoringDoc.Node node = new MonitoringDoc.Node(discoveryNode.getId(), discoveryNode.getHostName(), discoveryNode.getAddress().toString(), discoveryNode.getHostAddress(), discoveryNode.getName(), timestamp);
        new AsyncAction(this.threadPool, request, listener, this.exportService, cluster, timestamp, node).start();
    }

    private static MonitoringBulkResponse response(long start) {
        return new MonitoringBulkResponse(TransportMonitoringBulkAction.took(start), false);
    }

    private static MonitoringBulkResponse response(long start, Exception e) {
        return new MonitoringBulkResponse(TransportMonitoringBulkAction.took(start), new MonitoringBulkResponse.Error((Throwable)e));
    }

    private static long took(long start) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
    }

    static class AsyncAction {
        private final ThreadPool threadPool;
        private final MonitoringBulkRequest request;
        private final ActionListener<MonitoringBulkResponse> listener;
        private final Exporters exportService;
        private final String defaultClusterUUID;
        private final long defaultTimestamp;
        private final MonitoringDoc.Node defaultNode;

        AsyncAction(ThreadPool threadPool, MonitoringBulkRequest request, ActionListener<MonitoringBulkResponse> listener, Exporters exportService, String defaultClusterUUID, long defaultTimestamp, MonitoringDoc.Node defaultNode) {
            this.threadPool = threadPool;
            this.request = request;
            this.listener = listener;
            this.exportService = exportService;
            this.defaultClusterUUID = defaultClusterUUID;
            this.defaultTimestamp = defaultTimestamp;
            this.defaultNode = defaultNode;
        }

        void start() {
            this.executeExport(this.createMonitoringDocs(this.request.getDocs()), System.nanoTime(), this.listener);
        }

        Collection<MonitoringDoc> createMonitoringDocs(Collection<MonitoringBulkDoc> bulkDocs) {
            return bulkDocs.stream().filter(bulkDoc -> bulkDoc.getSystem() != MonitoredSystem.UNKNOWN).map(this::createMonitoringDoc).collect(Collectors.toList());
        }

        MonitoringDoc createMonitoringDoc(MonitoringBulkDoc bulkDoc) {
            MonitoredSystem system = bulkDoc.getSystem();
            String type = bulkDoc.getType();
            String id = bulkDoc.getId();
            long intervalMillis = bulkDoc.getIntervalMillis();
            XContentType xContentType = bulkDoc.getXContentType();
            BytesReference source = bulkDoc.getSource();
            long timestamp = bulkDoc.getTimestamp() != 0L ? bulkDoc.getTimestamp() : this.defaultTimestamp;
            return new BytesReferenceMonitoringDoc(this.defaultClusterUUID, timestamp, intervalMillis, this.defaultNode, system, type, id, xContentType, source);
        }

        void executeExport(final Collection<MonitoringDoc> docs, final long startTimeNanos, ActionListener<MonitoringBulkResponse> delegate) {
            this.threadPool.executor("generic").execute((Runnable)new ActionRunnable<MonitoringBulkResponse>(delegate){

                protected void doRun() {
                    exportService.export(docs, (ActionListener<Void>)ActionListener.wrap(r -> this.listener.onResponse((Object)TransportMonitoringBulkAction.response(startTimeNanos)), this::onFailure));
                }

                public void onFailure(Exception e) {
                    this.listener.onResponse((Object)TransportMonitoringBulkAction.response(startTimeNanos, e));
                }
            });
        }
    }
}

