/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.unsignedlong;

import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.script.Converter;
import org.elasticsearch.script.Converters;
import org.elasticsearch.script.Field;
import org.elasticsearch.script.FieldValues;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongFieldMapper;

public class UnsignedLongField
extends Field.LongField {
    public UnsignedLongField(String name, FieldValues<Long> values) {
        super(name, values);
    }

    public <CT, CF extends Field<CT>> Field<CT> convert(Converter<CT, CF> converter) {
        if (converter.getTargetClass() == BigInteger.class) {
            Field.BigIntegerField bigIntegerField = UnsignedLongField.UnsignedLongToBigInteger(this);
            return (Field)converter.getFieldClass().cast(bigIntegerField);
        }
        return super.as(converter);
    }

    static Field.BigIntegerField UnsignedLongToBigInteger(UnsignedLongField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.BigIntegerField(sourceField.getName(), (FieldValues)new Converters.DelegatingFieldValues<BigInteger, Long>(fv){

            protected BigInteger toBigInteger(long formatted) {
                return BigInteger.valueOf(formatted).and(UnsignedLongFieldMapper.BIGINTEGER_2_64_MINUS_ONE);
            }

            public List<BigInteger> getValues() {
                return this.values.getValues().stream().map(this::toBigInteger).collect(Collectors.toList());
            }

            public BigInteger getNonPrimitiveValue() {
                return this.toBigInteger(this.values.getLongValue());
            }
        });
    }
}

