/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class DeleteTransformAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteTransformAction INSTANCE = new DeleteTransformAction();
    public static final String NAME = "cluster:admin/transform/delete";

    private DeleteTransformAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String id;
        private final boolean force;

        public Request(String id, boolean force) {
            this.id = ExceptionsHelper.requireNonNull(id, TransformField.ID.getPreferredName());
            this.force = force;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.force = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readBoolean() : false;
        }

        public String getId() {
            return this.id;
        }

        public boolean isForce() {
            return this.force;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
                out.writeBoolean(this.force);
            }
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.force);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.id, other.id) && this.force == other.force;
        }
    }
}

