/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class TermsGroupConfig
implements Writeable,
ToXContentObject {
    public static final String NAME = "terms";
    private static final String FIELDS = "fields";
    private static final List<String> FLOAT_TYPES = Arrays.asList("half_float", "float", "double", "scaled_float");
    private static final List<String> NATURAL_TYPES = Arrays.asList("byte", "short", "integer", "long");
    private static final ConstructingObjectParser<TermsGroupConfig, Void> PARSER = new ConstructingObjectParser("terms", args -> {
        List fields = (List)args[0];
        return new TermsGroupConfig(fields != null ? fields.toArray(new String[fields.size()]) : null);
    });
    private final String[] fields;

    public TermsGroupConfig(String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("Fields must have at least one value");
        }
        this.fields = fields;
    }

    public TermsGroupConfig(StreamInput in) throws IOException {
        this.fields = in.readStringArray();
    }

    public String[] getFields() {
        return this.fields;
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Arrays.stream(this.fields).forEach(field -> {
            Map fieldCaps = (Map)fieldCapsResponse.get(field);
            if (fieldCaps != null && !fieldCaps.isEmpty()) {
                fieldCaps.forEach((key, value) -> {
                    if (key.equals("keyword") || key.equals("text")) {
                        if (!value.isAggregatable()) {
                            validationException.addValidationError("The field [" + field + "] must be aggregatable across all indices, but is not.");
                        }
                    } else if (FLOAT_TYPES.contains(key)) {
                        if (!value.isAggregatable()) {
                            validationException.addValidationError("The field [" + field + "] must be aggregatable across all indices, but is not.");
                        }
                    } else if (NATURAL_TYPES.contains(key)) {
                        if (!value.isAggregatable()) {
                            validationException.addValidationError("The field [" + field + "] must be aggregatable across all indices, but is not.");
                        }
                    } else {
                        validationException.addValidationError("The field referenced by a terms group must be a [numeric] or [keyword/text] type, but found " + fieldCaps.keySet().toString() + " for field [" + field + "]");
                    }
                });
            } else {
                validationException.addValidationError("Could not find a [numeric] or [keyword/text] field with name [" + field + "] in any of the indices matching the index pattern.");
            }
        });
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELDS, (Object)this.fields);
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.fields);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TermsGroupConfig that = (TermsGroupConfig)other;
        return Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static TermsGroupConfig fromXContent(XContentParser parser) throws IOException {
        return (TermsGroupConfig)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField(FIELDS, new String[0]));
    }
}

