/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.stats.CountAccumulator;
import org.elasticsearch.xpack.core.ml.stats.StatsAccumulator;

public class ForecastStats
implements ToXContentObject,
Writeable {
    private long total;
    private long forecastedJobs;
    private StatsAccumulator memoryStats;
    private StatsAccumulator recordStats;
    private StatsAccumulator runtimeStats;
    private CountAccumulator statusCounts;

    public ForecastStats() {
        this.total = 0L;
        this.forecastedJobs = 0L;
        this.memoryStats = new StatsAccumulator();
        this.recordStats = new StatsAccumulator();
        this.runtimeStats = new StatsAccumulator();
        this.statusCounts = new CountAccumulator();
    }

    public ForecastStats(long total, StatsAccumulator memoryStats, StatsAccumulator recordStats, StatsAccumulator runtimeStats, CountAccumulator statusCounts) {
        this.total = total;
        this.forecastedJobs = total > 0L ? 1L : 0L;
        this.memoryStats = Objects.requireNonNull(memoryStats);
        this.recordStats = Objects.requireNonNull(recordStats);
        this.runtimeStats = Objects.requireNonNull(runtimeStats);
        this.statusCounts = Objects.requireNonNull(statusCounts);
    }

    public ForecastStats(StreamInput in) throws IOException {
        this.total = in.readLong();
        this.forecastedJobs = in.readLong();
        this.memoryStats = new StatsAccumulator(in);
        this.recordStats = new StatsAccumulator(in);
        this.runtimeStats = new StatsAccumulator(in);
        this.statusCounts = new CountAccumulator(in);
    }

    public ForecastStats merge(ForecastStats other) {
        if (other == null) {
            return this;
        }
        this.total += other.total;
        this.forecastedJobs += other.forecastedJobs;
        this.memoryStats.merge(other.memoryStats);
        this.recordStats.merge(other.recordStats);
        this.runtimeStats.merge(other.runtimeStats);
        this.statusCounts.merge(other.statusCounts);
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public long getForecastedJobs() {
        return this.forecastedJobs;
    }

    public StatsAccumulator getMemoryStats() {
        return this.memoryStats;
    }

    public StatsAccumulator getRecordStats() {
        return this.recordStats;
    }

    public StatsAccumulator getRuntimeStats() {
        return this.runtimeStats;
    }

    public CountAccumulator getStatusCounts() {
        return this.statusCounts;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder, params);
        return builder.endObject();
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("total", this.total);
        builder.field("forecasted_jobs", this.forecastedJobs);
        if (this.total > 0L) {
            builder.field("memory_bytes", this.memoryStats.asMap());
            builder.field("records", this.recordStats.asMap());
            builder.field("processing_time_ms", this.runtimeStats.asMap());
            builder.field("status", this.statusCounts.asMap());
        }
        return builder;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", this.total);
        map.put("forecasted_jobs", this.forecastedJobs);
        if (this.total > 0L) {
            map.put("memory_bytes", this.memoryStats.asMap());
            map.put("records", this.recordStats.asMap());
            map.put("processing_time_ms", this.runtimeStats.asMap());
            map.put("status", this.statusCounts.asMap());
        }
        return map;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.total);
        out.writeLong(this.forecastedJobs);
        this.memoryStats.writeTo(out);
        this.recordStats.writeTo(out);
        this.runtimeStats.writeTo(out);
        this.statusCounts.writeTo(out);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.forecastedJobs, this.memoryStats, this.recordStats, this.runtimeStats, this.statusCounts);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForecastStats other = (ForecastStats)obj;
        return Objects.equals(this.total, other.total) && Objects.equals(this.forecastedJobs, other.forecastedJobs) && Objects.equals(this.memoryStats, other.memoryStats) && Objects.equals(this.recordStats, other.recordStats) && Objects.equals(this.runtimeStats, other.runtimeStats) && Objects.equals(this.statusCounts, other.statusCounts);
    }

    public static class Fields {
        public static final String TOTAL = "total";
        public static final String FORECASTED_JOBS = "forecasted_jobs";
        public static final String MEMORY = "memory_bytes";
        public static final String RUNTIME = "processing_time_ms";
        public static final String RECORDS = "records";
        public static final String STATUSES = "status";
    }
}

