/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.snapshot.upgrade;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeState;

public class SnapshotUpgradeTaskState
implements PersistentTaskState {
    public static final String NAME = "xpack/ml/job/snapshot/upgrade";
    private static ParseField STATE = new ParseField("state", new String[0]);
    private static ParseField ALLOCATION_ID = new ParseField("allocation_id", new String[0]);
    private static ParseField REASON = new ParseField("reason", new String[0]);
    private final SnapshotUpgradeState state;
    private final long allocationId;
    private final String reason;
    private static final ConstructingObjectParser<SnapshotUpgradeTaskState, Void> PARSER = new ConstructingObjectParser("xpack/ml/job/snapshot/upgrade", true, a -> new SnapshotUpgradeTaskState((SnapshotUpgradeState)a[0], (Long)a[1], (String)a[2]));

    public static SnapshotUpgradeTaskState fromXContent(XContentParser parser) {
        try {
            return (SnapshotUpgradeTaskState)PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SnapshotUpgradeTaskState(SnapshotUpgradeState state, long allocationId, @Nullable String reason) {
        this.state = Objects.requireNonNull(state);
        this.allocationId = allocationId;
        this.reason = reason;
    }

    public SnapshotUpgradeTaskState(StreamInput in) throws IOException {
        this.state = SnapshotUpgradeState.fromStream(in);
        this.allocationId = in.readLong();
        this.reason = in.readOptionalString();
    }

    public SnapshotUpgradeState getState() {
        return this.state;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.state.writeTo(out);
        out.writeLong(this.allocationId);
        out.writeOptionalString(this.reason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(STATE.getPreferredName(), this.state.toString());
        builder.field(ALLOCATION_ID.getPreferredName(), this.allocationId);
        if (this.reason != null) {
            builder.field(REASON.getPreferredName(), this.reason);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotUpgradeTaskState that = (SnapshotUpgradeTaskState)o;
        return this.allocationId == that.allocationId && this.state == that.state && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.allocationId, this.reason);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SnapshotUpgradeState::fromString, STATE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), ALLOCATION_ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
    }
}

