/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DataFrameAnalyticsConfigUpdate
implements Writeable,
ToXContentObject {
    public static final ConstructingObjectParser<Builder, Void> PARSER = new ConstructingObjectParser("data_frame_analytics_config_update", args -> new Builder((String)args[0]));
    private final String id;
    private final String description;
    private final ByteSizeValue modelMemoryLimit;
    private final Boolean allowLazyStart;
    private final Integer maxNumThreads;

    private DataFrameAnalyticsConfigUpdate(String id, @Nullable String description, @Nullable ByteSizeValue modelMemoryLimit, @Nullable Boolean allowLazyStart, @Nullable Integer maxNumThreads) {
        this.id = id;
        this.description = description;
        this.modelMemoryLimit = modelMemoryLimit;
        this.allowLazyStart = allowLazyStart;
        if (maxNumThreads != null && maxNumThreads < 1) {
            throw ExceptionsHelper.badRequestException("[{}] must be a positive integer", DataFrameAnalyticsConfig.MAX_NUM_THREADS.getPreferredName());
        }
        this.maxNumThreads = maxNumThreads;
    }

    public DataFrameAnalyticsConfigUpdate(StreamInput in) throws IOException {
        this.id = in.readString();
        this.description = in.readOptionalString();
        this.modelMemoryLimit = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
        this.allowLazyStart = in.readOptionalBoolean();
        this.maxNumThreads = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readOptionalVInt() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalString(this.description);
        out.writeOptionalWriteable((Writeable)this.modelMemoryLimit);
        out.writeOptionalBoolean(this.allowLazyStart);
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeOptionalVInt(this.maxNumThreads);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteSizeValue getModelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public Boolean isAllowLazyStart() {
        return this.allowLazyStart;
    }

    public Integer getMaxNumThreads() {
        return this.maxNumThreads;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DataFrameAnalyticsConfig.ID.getPreferredName(), this.id);
        if (this.description != null) {
            builder.field(DataFrameAnalyticsConfig.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.modelMemoryLimit != null) {
            builder.field(DataFrameAnalyticsConfig.MODEL_MEMORY_LIMIT.getPreferredName(), this.modelMemoryLimit.getStringRep());
        }
        if (this.allowLazyStart != null) {
            builder.field(DataFrameAnalyticsConfig.ALLOW_LAZY_START.getPreferredName(), this.allowLazyStart);
        }
        if (this.maxNumThreads != null) {
            builder.field(DataFrameAnalyticsConfig.MAX_NUM_THREADS.getPreferredName(), this.maxNumThreads);
        }
        builder.endObject();
        return builder;
    }

    public DataFrameAnalyticsConfig.Builder mergeWithConfig(DataFrameAnalyticsConfig source) {
        if (!this.id.equals(source.getId())) {
            throw new IllegalArgumentException("Cannot apply update to a config with different id");
        }
        DataFrameAnalyticsConfig.Builder builder = new DataFrameAnalyticsConfig.Builder(source);
        if (this.description != null) {
            builder.setDescription(this.description);
        }
        if (this.modelMemoryLimit != null) {
            builder.setModelMemoryLimit(this.modelMemoryLimit);
        }
        if (this.allowLazyStart != null) {
            builder.setAllowLazyStart(this.allowLazyStart);
        }
        if (this.maxNumThreads != null) {
            builder.setMaxNumThreads(this.maxNumThreads);
        }
        return builder;
    }

    public boolean requiresRestart(DataFrameAnalyticsConfig source) {
        return this.getModelMemoryLimit() != null && !this.getModelMemoryLimit().equals((Object)source.getModelMemoryLimit()) || this.getMaxNumThreads() != null && !this.getMaxNumThreads().equals(source.getMaxNumThreads());
    }

    public Set<String> getUpdatedFields() {
        TreeSet<String> updatedFields = new TreeSet<String>();
        if (this.description != null) {
            updatedFields.add(DataFrameAnalyticsConfig.DESCRIPTION.getPreferredName());
        }
        if (this.modelMemoryLimit != null) {
            updatedFields.add(DataFrameAnalyticsConfig.MODEL_MEMORY_LIMIT.getPreferredName());
        }
        if (this.allowLazyStart != null) {
            updatedFields.add(DataFrameAnalyticsConfig.ALLOW_LAZY_START.getPreferredName());
        }
        if (this.maxNumThreads != null) {
            updatedFields.add(DataFrameAnalyticsConfig.MAX_NUM_THREADS.getPreferredName());
        }
        return updatedFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataFrameAnalyticsConfigUpdate)) {
            return false;
        }
        DataFrameAnalyticsConfigUpdate that = (DataFrameAnalyticsConfigUpdate)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && Objects.equals(this.modelMemoryLimit, that.modelMemoryLimit) && Objects.equals(this.allowLazyStart, that.allowLazyStart) && Objects.equals(this.maxNumThreads, that.maxNumThreads);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.modelMemoryLimit, this.allowLazyStart, this.maxNumThreads);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DataFrameAnalyticsConfig.ID);
        PARSER.declareStringOrNull(Builder::setDescription, DataFrameAnalyticsConfig.DESCRIPTION);
        PARSER.declareField(Builder::setModelMemoryLimit, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)DataFrameAnalyticsConfig.MODEL_MEMORY_LIMIT.getPreferredName()), DataFrameAnalyticsConfig.MODEL_MEMORY_LIMIT, ObjectParser.ValueType.VALUE);
        PARSER.declareBoolean(Builder::setAllowLazyStart, DataFrameAnalyticsConfig.ALLOW_LAZY_START);
        PARSER.declareInt(Builder::setMaxNumThreads, DataFrameAnalyticsConfig.MAX_NUM_THREADS);
    }

    public static class Builder {
        private String id;
        private String description;
        private ByteSizeValue modelMemoryLimit;
        private Boolean allowLazyStart;
        private Integer maxNumThreads;

        public Builder(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setModelMemoryLimit(ByteSizeValue modelMemoryLimit) {
            this.modelMemoryLimit = modelMemoryLimit;
            return this;
        }

        public Builder setAllowLazyStart(Boolean allowLazyStart) {
            this.allowLazyStart = allowLazyStart;
            return this;
        }

        public Builder setMaxNumThreads(Integer maxNumThreads) {
            this.maxNumThreads = maxNumThreads;
            return this;
        }

        public DataFrameAnalyticsConfigUpdate build() {
            return new DataFrameAnalyticsConfigUpdate(this.id, this.description, this.modelMemoryLimit, this.allowLazyStart, this.maxNumThreads);
        }
    }
}

