/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CopySettingsStep
extends ClusterStateActionStep {
    public static final String NAME = "copy-settings";
    private static final Logger logger = LogManager.getLogger(CopySettingsStep.class);
    private final String[] settingsKeys;
    private final String indexPrefix;

    public CopySettingsStep(Step.StepKey key, Step.StepKey nextStepKey, String indexPrefix, String ... settingsKeys) {
        super(key, nextStepKey);
        Objects.requireNonNull(indexPrefix);
        Objects.requireNonNull(settingsKeys);
        this.indexPrefix = indexPrefix;
        this.settingsKeys = settingsKeys;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public String[] getSettingsKeys() {
        return this.settingsKeys;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        String sourceIndexName = index.getName();
        IndexMetadata sourceIndexMetadata = clusterState.metadata().index(sourceIndexName);
        String targetIndexName = this.indexPrefix + sourceIndexName;
        IndexMetadata targetIndexMetadata = clusterState.metadata().index(targetIndexName);
        if (sourceIndexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)sourceIndexName);
            return clusterState;
        }
        if (this.settingsKeys == null || this.settingsKeys.length == 0) {
            return clusterState;
        }
        if (targetIndexMetadata == null) {
            String errorMessage = String.format(Locale.ROOT, "index [%s] is being referenced by ILM action [%s] on step [%s] but it doesn't exist", targetIndexName, this.getKey().getAction(), this.getKey().getName());
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        Settings.Builder settings = Settings.builder().put(targetIndexMetadata.getSettings());
        for (String key : this.settingsKeys) {
            String value = sourceIndexMetadata.getSettings().get(key);
            settings.put(key, value);
        }
        Metadata.Builder newMetaData = Metadata.builder((Metadata)clusterState.getMetadata()).put(IndexMetadata.builder((IndexMetadata)targetIndexMetadata).settingsVersion(targetIndexMetadata.getSettingsVersion() + 1L).settings(settings));
        return ClusterState.builder((ClusterState)clusterState).metadata(newMetaData).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CopySettingsStep that = (CopySettingsStep)o;
        return Objects.equals(this.settingsKeys, that.settingsKeys) && Objects.equals(this.indexPrefix, that.indexPrefix);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.settingsKeys, this.indexPrefix);
    }
}

