/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Objects;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;

public class AggSource {
    private final String fieldName;
    private final ScriptTemplate script;

    private AggSource(String fieldName, ScriptTemplate script) {
        this.fieldName = fieldName;
        this.script = script;
    }

    public static AggSource of(String fieldName) {
        return new AggSource(fieldName, null);
    }

    public static AggSource of(ScriptTemplate script) {
        return new AggSource(null, script);
    }

    ValuesSourceAggregationBuilder with(ValuesSourceAggregationBuilder aggBuilder) {
        if (this.fieldName != null) {
            return aggBuilder.field(this.fieldName);
        }
        return aggBuilder.script(this.script.toPainless());
    }

    public String fieldName() {
        return this.fieldName;
    }

    public ScriptTemplate script() {
        return this.script;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.script);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggSource aggSource = (AggSource)o;
        return Objects.equals(this.fieldName, aggSource.fieldName) && Objects.equals(this.script, aggSource.script);
    }

    public String toString() {
        return this.fieldName != null ? this.fieldName : this.script.toString();
    }
}

