/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.AbstractGeoHashGridTiler;

public class BoundedGeoHashGridTiler
extends AbstractGeoHashGridTiler {
    private final GeoBoundingBox bbox;
    private final boolean crossesDateline;
    private final long maxHashes;

    public BoundedGeoHashGridTiler(int precision, GeoBoundingBox bbox) {
        super(precision);
        long hashesX;
        this.bbox = bbox;
        this.crossesDateline = bbox.right() < bbox.left();
        long hashesY = (long)Math.ceil((bbox.top() - bbox.bottom()) / Geohash.latHeightInDegrees((int)precision) + 1.0);
        if (this.crossesDateline) {
            long hashesLeft = (long)Math.ceil((180.0 - bbox.left()) / Geohash.lonWidthInDegrees((int)precision) + 1.0);
            long hashesRight = (long)Math.ceil((bbox.right() + 180.0) / Geohash.lonWidthInDegrees((int)precision) + 1.0);
            hashesX = hashesLeft + hashesRight;
        } else {
            hashesX = (long)Math.ceil((bbox.right() - bbox.left()) / Geohash.lonWidthInDegrees((int)precision) + 1.0);
        }
        this.maxHashes = hashesX * hashesY;
    }

    @Override
    protected long getMaxCells() {
        return this.maxHashes;
    }

    @Override
    protected boolean validHash(String hash) {
        Rectangle rectangle = Geohash.toBoundingBox((String)hash);
        if (this.bbox.top() > rectangle.getMinY() && this.bbox.bottom() < rectangle.getMaxY()) {
            if (this.crossesDateline) {
                return this.bbox.left() < rectangle.getMaxX() || this.bbox.right() > rectangle.getMinX();
            }
            return this.bbox.left() < rectangle.getMaxX() && this.bbox.right() > rectangle.getMinX();
        }
        return false;
    }
}

